% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_benchmark.R
\name{PerformSparseMatrixKernelMicrobenchmarking}
\alias{PerformSparseMatrixKernelMicrobenchmarking}
\title{Performs microbenchmarking of sparse matrix kernels specified by an input
list}
\usage{
PerformSparseMatrixKernelMicrobenchmarking(microbenchmarks, numberOfThreads,
  runIdentifier, resultsDirectory)
}
\arguments{
\item{microbenchmarks}{a list of
\code{SparseMatrixMicrobenchmark} objects defining the sparse matrix
microbenchmarks to be executed as part of the sparse matrix
benchmark.}

\item{numberOfThreads}{the number of threads the microbenchmarks are
intended to be executed with; the value is for display purposes only as
the number of threads used is assumed to be controlled through environment
variables}

\item{runIdentifier}{a character string specifying the suffix to be
appended to the base of the file name of the output CSV format files}

\item{resultsDirectory}{a character string specifying the directory
where all of the CSV performance results files will be saved}
}
\value{
a data frame containing the benchmark name, user, system, and
  elapsed (wall clock) times of each performance trial for each
  microbenchmark
}
\description{
\code{PerformSparseMatrixKernelMicrobenchmarking} performs microbenchmarking
of sparse matrix kernels specified by the input list of
\code{SparseMatrixMicrobenchmark} objects.  Objects with the \code{active}
flag set to TRUE indicate that the corresponding microbenchmark will be
performed; FALSE indicates that the microbenchmark will be skipped.
If the \code{matrixObjectName} field of an input
\code{SparseMatrixMicrobenchmark} object is set to \code{NA_character_},
then the sparse matrix is assumed to be dynamically generated by the
allocator function specified in the \code{allocatorFunction} field.
If the \code{matrixObjectName} field is specified, then the sparse
matrix object is expected to be found in an \code{.RData} file with
base file name the same as the value of \code{matrixObjectName}, and
located in the either an attached R data package or a directory named
\code{data} in the current working directory.  See the
the \code{\link[utils]{data}} package for more details.
}
\seealso{
\code{\link[utils]{data}}
}
