% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microbenchmark_clustering_kernel.R
\name{MicrobenchmarkClusteringKernel}
\alias{MicrobenchmarkClusteringKernel}
\title{Performs microbenchmarking of a clustering for machine learning kernel}
\usage{
MicrobenchmarkClusteringKernel(benchmarkParameters, numberOfThreads,
  resultsDirectory, runIdentifier)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{ClusteringMicrobenchmark}} specifying the data set
to be read in or generated and the number of performance trials
to perform with the data set.}

\item{numberOfThreads}{the number of threads the microbenchmark is being
performed with.  The value is for informational purposes only and does not
effect the number threads the kernel is executed with.}

\item{resultsDirectory}{a character string specifying the directory
where all of the CSV performance results files will be saved}

\item{runIdentifier}{a character string specifying the suffix to be
appended to the base of the file name of the output CSV format files}
}
\value{
a dataframe containing the performance trial times for the given
  kernel and data set being tested, that is the raw performance data before
  averaging.  The columns of the data frame are the following:
  \describe{
    \item{BenchmarkName}{The name of the microbenchmark}
    \item{NumberOfFeatures}{The number of features in each feature vector}
    \item{NumberOfFeatureVectors}{The number of features in the data set}
    \item{NumberOfClusters}{The number of clusters in the data set}
    \item{UserTime}{The amount of time spent in user-mode code within the
      microbenchmarked code}
    \item{SystemTime}{The amount of time spent in the kernel within the
      process}
    \item{WallClockTime}{The total time spent to complete the performance
      trial}
    \item{DateStarted}{The date and time the performance trial was commenced}
    \item{DateFinished}{The date and time the performance trial ended}
  }
}
\description{
\code{MicrobenchmarkClusteringKernel} performs microbenchmarking of a
clustering for machine learning kernel for a given data set
}
\details{
This function performs microbenchmarking of a clustering for machine learning
kernel for a given data set and a given number of threads.  The
kernel to be performance tested and other parameters specifying how the
kernel is to be benchmarked are given in the input object
\code{benchmarkParameters} which is an instance of the class
\code{\link{ClusteringMicrobenchmark}}.  The
performance results are averaged over the number of performance trials
and written to a CSV file.  The results of the individual performance
trials are retained in a data frame that is returned upon completion of the
microbenchmark.  The kernel can be executed with multiple threads if the
kernel supports multithreading.  See
\code{\link{ClusteringMicrobenchmark}} for more details on the
benchmarking parameters.
}
