% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDHonest.R
\name{RDHonest}
\alias{RDHonest}
\title{Honest inference in RD}
\usage{
RDHonest(
  formula,
  data,
  subset,
  weights,
  cutoff = 0,
  M,
  kern = "triangular",
  na.action,
  opt.criterion = "MSE",
  h,
  se.method = "nn",
  alpha = 0.05,
  beta = 0.8,
  J = 3,
  sclass = "H",
  T0 = 0,
  point.inference = FALSE,
  sigmaY2,
  sigmaD2,
  sigmaYD,
  clusterid
)
}
\arguments{
\item{formula}{an object of class \code{"formula"} (or one that can be
coerced to that class). The formula syntax is \code{outcome ~
running_variable} for inference at a point. For sharp RD, it is
\code{outcome ~ running_variable} if there are no covariates, or
\code{outcome ~ running_variable | covariates} if covariates are present.
For fuzzy RD, it is \code{outcome | treatment ~ running_variable |
covariates}, with \code{covariates} optional.}

\item{data}{optional data frame, list or environment (or object coercible by
\code{as.data.frame} to a data frame) containing the outcome and running
variables in the model. If not found in \code{data}, the variables are
taken from \code{environment(formula)}, typically the environment from
which the function is called.}

\item{subset}{optional vector specifying a subset of observations to be used
in the fitting process.}

\item{weights}{Optional vector of weights to weight the observations (useful
for aggregated data). The weights are interpreted as the number of
observations that each aggregated data point averages over. Disregarded
if optimal kernel is used.}

\item{cutoff}{specifies the RD cutoff in the running variable. For inference
at a point, specifies the point \eqn{x_0} at which to calculate the
conditional mean.}

\item{M}{Bound on second derivative of the conditional mean function, a
numeric vector of length one. For fuzzy RD, \code{M} needs to be a
numeric vector of length two, specifying the smoothness of the
conditional mean for the outcome and treatment, respectively.}

\item{kern}{specifies the kernel function used in the local regression. It
can either be a string equal to \code{"triangular"}
(\eqn{k(u)=(1-|u|)_{+}}), \code{"epanechnikov"}
(\eqn{k(u)=(3/4)(1-u^2)_{+}}), or \code{"uniform"} (\eqn{k(u)=
(|u|<1)/2}), or else a kernel function. If equal to \code{"optimal"}, use
the finite-sample optimal linear estimator under Taylor smoothness class,
instead of a local linear estimator.}

\item{na.action}{function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{options} (usually \code{na.omit}). Another possible value is
\code{na.fail}}

\item{opt.criterion}{Optimality criterion that the bandwidth is designed to
    optimize. The options are:

   \describe{

   \item{\code{"MSE"}}{Finite-sample maximum MSE}

   \item{\code{"FLCI"}}{Length of (fixed-length) two-sided
       confidence intervals.}

   \item{\code{"OCI"}}{Given quantile of excess length of one-sided
       confidence intervals}

    }

    The methods use conditional variance given by \code{sigmaY2}, if
    supplied. For fuzzy RD, \code{sigmaD2} and \code{sigmaYD} also need to be
    supplied in this case. Otherwise, the methods use preliminary variance
    estimates based on assuming homoskedasticity on either side of the
    cutoff.}

\item{h}{bandwidth, a scalar parameter. If not supplied, optimal bandwidth is
computed according to criterion given by \code{opt.criterion}.}

\item{se.method}{method for estimating standard error of the estimate, one
    of:

\describe{
    \item{"nn"}{Nearest neighbor method}

    \item{"EHW"}{Eicker-Huber-White, with residuals from local regression
    (local polynomial estimators only).}

   \item{"supplied.var"}{Use conditional variance supplied by \code{sigmaY2}
        instead of computing residuals. For fuzzy RD, \code{sigmaD2} and
        \code{sigmaYD} also need to be supplied in this case.}

}}

\item{alpha}{determines confidence level, \code{1-alpha} for
constructing/optimizing confidence intervals.}

\item{beta}{Determines quantile of excess length to optimize, if bandwidth
optimizes given quantile of excess length of one-sided confidence
intervals (\code{opt.criterion="OCI"}); otherwise ignored.}

\item{J}{Number of nearest neighbors, if \code{se.method="nn"} is specified.
Otherwise ignored.}

\item{sclass}{Smoothness class, either \code{"T"} for Taylor or \code{"H"}
for Hölder class.}

\item{T0}{Initial estimate of the treatment effect for calculating the
optimal bandwidth. Only relevant for fuzzy RD.}

\item{point.inference}{Do inference at a point determined by \code{cutoff}
instead of RD.}

\item{sigmaY2}{Supply variance of outcome. Ignored when kernel is optimal.}

\item{sigmaD2}{Supply variance of treatment (fuzzy RD only).}

\item{sigmaYD}{Supply covariance of treatment and outcome (fuzzy RD only).}

\item{clusterid}{Vector specifying cluster membership. If supplied,
\code{se.method="EHW"} is required, and standard errors use
cluster-robust variance formulas.}
}
\value{
Returns an object of class \code{"RDResults"}. The function
    \code{print} can be used to obtain and print a summary of the results. An
    object of class \code{"RDResults"} is a list containing four components.
    First, a data frame \code{"coefficients"} containing the following
    columns:

    \describe{
    \item{\code{term}}{type of parameter being estimated}

    \item{\code{estimate}}{point estimate}

    \item{\code{std.error}}{standard error of \code{estimate}}

    \item{\code{maximum.bias}}{maximum bias of \code{estimate}}

    \item{\code{conf.low}, \code{conf.high}}{lower (upper) end-point of a
    two-sided CI based on \code{estimate}}

    \item{\code{conf.low.onesided}, \code{conf.high.onesided}}{lower (upper)
        end-point of a one-sided CIs based on \code{estimate}}

    \item{\code{bandwidth}}{bandwidth used. If \code{kern="optimal"}, the
      smoothing parameters \code{bandwidth.m} and \code{bandwidth.p} on
      either side of the cutoff are reported instead}

    \item{\code{eff.obs}}{number of effective observations}

    \item{\code{leverage}}{maximal leverage of \code{estimate}}

    \item{\code{cv}}{critical value used to compute two-sided CIs}

    \item{\code{alpha}}{coverage level, as specified by option \code{alpha}}

    \item{\code{method}}{\code{sclass} is used}

     \item{\code{M}}{curvature bound used for worst-case bias
        calculations. For fuzzy RD, equals
        \code{(abs(estimate)*M.fs+M.rf)/first.stage}}

     \item{\code{M.rf}, \code{M.fs}}{curvature bound for the outcome (i.e.
     reduced-form) and first-stage regressions. Fuzzy RD only.}

      \item{\code{first.stage}}{estimate of the first-stage coefficient.
      Fuzzy RD only.}

      \item{\code{kernel}}{kernel used}

       \item{\code{p.value}}{p-value for testing the null of no effect}
     }

    Second, a list called \code{"data"} containing the data used for
    estimation. This is useful mostly for internal calculations. Third, an
    object of class \code{"lm"} containing the local linear regression
    estimates. Finally, a \code{call} object containing the matched call
    called \code{"call"}.

    If \code{kern="optimal"}, the \code{"lm"} object is empty, and the
    numeric vectors \code{"delta"} and \code{"omega"} are returned in
    addition. These correspond to the parameters in the modulus problem used
    to compute the optimal estimation weights.
}
\description{
Calculate estimators and bias-aware CIs for the sharp or fuzzy RD parameter,
or for value of the conditional mean at a point.
}
\details{
The bandwidth is calculated to be optimal for a given performance criterion,
as specified by \code{opt.criterion}. Alternatively, for local polynomial
estimators, the bandwidth can be specified by \code{h}. For
\code{kern="optimal"}, calculate optimal estimators under second-order Taylor
smoothness class (sharp RD only).
}
\section{Note}{

\code{subset} is evaluated in the same way as variables in \code{formula},
that is first in \code{data} and then in the environment of \code{formula}.
}

\examples{
RDHonest(voteshare ~ margin, data = lee08, kern = "uniform", M = 0.1, h = 10)
RDHonest(cn | retired ~ elig_year, data=rcp, cutoff=0, M=c(4, 0.4),
          kern="triangular", opt.criterion="MSE", T0=0, h=3)
RDHonest(voteshare ~ margin, data = lee08, subset = margin>0,
          kern = "uniform", M = 0.1, h = 10, point.inference=TRUE)
}
\references{
{

\cite{Timothy B. Armstrong and Michal Kolesár. Optimal inference in a class
of regression models. Econometrica, 86(2):655–683, March 2018.
\doi{10.3982/ECTA14434}}

\cite{Timothy B. Armstrong and Michal Kolesár. Simple and honest confidence
intervals in nonparametric regression. Quantitative Economics, 11(1):1–39,
January 2020. \doi{10.3982/QE1199}}

\cite{Michal Kolesár and Christoph Rothe. Inference in regression
discontinuity designs with a discrete running variable. American Economic
Review, 108(8):2277—-2304, August 2018. \doi{10.1257/aer.20160945}}

}
}
