% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/republika.R
\name{republika}
\alias{republika}
\title{Republika}
\source{
© ČÚZK, 2021 \url{https://vdp.cuzk.cz/}
}
\usage{
republika(resolution = "high")
}
\arguments{
\item{resolution}{Should the function return high or low resolution shapefile? Allowed values are "high" (default) and "low". This parameter affects only the geometry column, all other fields remain the same.}
}
\value{
\code{sf} data frame with 1 row of 1 variable + geometry:
}
\description{
Boundaries of the Czech Republic as \code{sf} polygon.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package).

The dataset is based on RUIAN data by the Czech cadastral office. If necessary you can download the most up to date raw dataset in VFR format (a special case of XML which is understood by GDAL) on \url{https://vdp.cuzk.cz/vdp/ruian/vymennyformat} (in Czech only).

The data is current to June 2024. Downloaded size of high resolution shapefile is <1 MB; low resolution object is internal.
}
\examples{
library(sf)

hranice <- republika("low")
plot(hranice, col = "white")

}
