% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regC.r
\name{regC}
\alias{regC}
\title{Linear regression analysis (OLS regression), with options for weighted observations, diagnostic tests, and plots of residuals}
\usage{
regC(formula, w, data, digits = 3, anova = FALSE, norm.test = FALSE,
  ncv.test = FALSE, linear.test = FALSE, reset.test = FALSE,
  outlier.test = FALSE, vif = FALSE, printC = FALSE, res.plots = FALSE,
  ...)
}
\arguments{
\item{formula}{should be in dataset$dv ~ datatset$iv1 + dataset$iv2 unless dataset specified in optional data argument. If weights are specified using w argument, the formula cannot contain functions or logical statements (all variables in the function must be named in the dataset).}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains dv, iv (and w) variables.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 2).}

\item{anova}{(Optional) Do you want ANOVA table reporting F-test for all predictors? (default: FALSE)}

\item{norm.test}{(Optional) Test assumption that regression residuals follow normal distribution (default: FALSE)}

\item{ncv.test}{(Optional) Test assumption that regression residuals have constant variance (default: FALSE)}

\item{linear.test}{(Optional) Report results of linearity test? (default: FALSE)}

\item{reset.test}{(Optional) Report results of model specification test? (default: FALSE)}

\item{outlier.test}{(Optional) Test whether outlier observations have outsized leverage on results (default: FALSE)}

\item{vif}{(Optional) Report variance inflation factors to assess multicollinearity? (default: FALSE)}

\item{printC}{(Optional) Do you want to print tables of results (and residuals plots if res.plots=TRUE) to .html file in working directory? (default: FALSE)}

\item{res.plots}{(Optional)}

\item{...}{(Optional) Additional arguments passed to \code{\link[stats]{lm}} function (unweighted models) or \code{\link[survey]{svyglm}} function (weighted models).}
}
\value{
Returns a lm or svyglm object.
}
\description{
Linear regression analysis function with many useful features. Standard output of results includes table of coefficients, table of residuals, and additional model information. Options for weighting observations, analysis of variance (ANOVA), performing post-estimation diagnostic tests, including testing normality of residuals and constant variance, and generating diagnostic plots of residuals.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=53NPD-BGvwU}{Bivariate Regression Analysis with RCPA3 Package's regC Function} 10:31
\item \href{https://youtu.be/17Dxg5D3qtQ}{Multiple Regression Analysis with RCPA3 Package's regC Function} 14:55
\item \href{https://youtu.be/97hoiYuQnl4}{Analyzing Regression Residuals with RCPA3 Package's regC Function} 12:41
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapters 11, 12, 13.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 244-271. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=11}{R Tutorials & Resources for Correlation and Bivariate Regression}, \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=12}{Multiple Regression}, and \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=13}{Analyzing Regression Residuals}, compiled by Barry C. Edwards.
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
  library(RCPA3)
  
  \dontrun{ 
  # basic usage
  regC(states$vep20.turnout ~ states$hs.or.more)
   
  # with w and data arguments
  regC(nes$ft.unions ~ nes$ft.dem, w=nes$wt)
  
  # multiple IV with some post-estimation tests
  regC(peace.index ~ vdem.edi.score + hdi, data=world, norm.test=TRUE, ncv.test=TRUE)
  }
}
