% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferenceFunk.R
\name{logPosterior_BaM_wrapped}
\alias{logPosterior_BaM_wrapped}
\title{BaM log-posterior}
\usage{
logPosterior_BaM_wrapped(
  parvector,
  X,
  Yobs,
  Yu,
  lpfunk,
  llfunk,
  mod,
  Ysim = NULL,
  logLikelihood_engine = logLikelihood_BaM,
  llargs = NULL
)
}
\arguments{
\item{parvector}{numeric vector, parameter vector, including thetas (model parameters)
and gammas (structural errors parameters).}

\item{X}{data frame, model inputs.}

\item{Yobs}{data frame, corresponding observed values.}

\item{Yu}{data frame, measurement uncertainties (standard deviations), same dimensions as Yobs.}

\item{lpfunk}{function, function computing the log-prior density of parvector.}

\item{llfunk}{function, function computing the log-likelihood given Ysim, see e.g. \link[RBaM]{llfunk_iid_Gaussian}.}

\item{mod}{model object, the model to be calibrated.}

\item{Ysim}{data frame, model-simulated values. When NULL (default), the model is run to provide simulations.
When a non-NULL data frame is provided, it is used as pre-computed simulations, and the model is
hence not run. This is useful to speed-up some MCMC strategies.}

\item{logLikelihood_engine}{function, engine function used to compute the log-likelihood, see e.g. \link[RBaM]{logLikelihood_BaM}.
Unlike functions llfunk, which computes the log-likelihood from model-simulated values Ysim (see e.g. \link[RBaM]{llfunk_iid_Gaussian},
logLikelihood_engine computes the log-likelihood from (parameters + inputs X + model mod).}

\item{llargs}{object, any other arguments to be passed to llfunk.}
}
\value{
the unnormalized posterior log-pdf (numeric).
}
\description{
Log-posterior engine for a model available in BaM. This is a wrapped version of
\link[RBaM]{logPosterior_BaM}, returning a single numeric value (the log-posterior).
This function can hence be passed to standard optimization (e.g. \link[stats]{optim})
or MCMC (e.g. \link[mcmc]{metrop}) tools.
}
\examples{
# Single-control rating curve model - see https://github.com/BaM-tools/RBaM
# Parameters are activation stage k, coefficient a and exponent c
k=parameter(name='k',init=-0.5)
a=parameter(name='a',init=100)
c=parameter(name='c',init=1.6)
# Define control matrix: columns are controls, rows are stage ranges.
controlMatrix=matrix(1,nrow=1,ncol=1)
# Stitch it all together into a model object
M=model(ID='BaRatin',
        nX=1,nY=1, # number of input/output variables
        par=list(k,a,c), # list of model parameters
        xtra=xtraModelInfo(object=controlMatrix)) # use xtraModelInfo() to pass the control matrix
# Define calibration data
X=SauzeGaugings['H']
Yobs=SauzeGaugings['Q']
Yu=SauzeGaugings['uQ']
# Define the parameter vector (model parameters + structural error parameters)
parvector=c(RBaM::getInitPar(M$par),c(1,0.1))
# Define prior function - here for instance just an informative prior on the third parameter
myPrior <-function(parvector){dnorm(parvector[3],1.6,0.1,log=TRUE)}
# Compute log-likelihood
logPosterior_BaM_wrapped(parvector=parvector,X=X,Yobs=Yobs,Yu=Yu,
                 lpfunk=myPrior,llfunk=llfunk_iLinear_Gaussian,mod=M)
}
