% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R0.R.R
\name{plot.R0.R}
\alias{plot.R0.R}
\title{Plot the R0/Rt value along with confidence interval}
\usage{
\method{plot}{R0.R}(x, xscale = "w", TD.split = FALSE, ...)
}
\arguments{
\item{x}{An estimated object, output from \code{est.R0.xx()} routines (class \code{R0.R}).}

\item{xscale}{Scale to be adjusted on x-axis. Can be \code{d} (day), \code{w} (week (default)), \code{f} (fornight), \code{m} (month).}

\item{TD.split}{Boolean. Parameter to force the display of both \eqn{R(t)} and the epidemic curve in the same window for the TD method.}

\item{...}{Parameters passed to inner functions.}
}
\value{
This function does not return any data.
Called for side effect. Draws all \eqn{R_{0}} or /eqn{R(t)} values from one estimation method.
}
\description{
Generates the graphical output for an estimated \eqn{R} or \eqn{R(t)}. The
graph depends on the estimation method. In general, the estimated value is
presented along with its confidence interval.
}
\details{
For internal use. This function is called when using \code{\link[=plot.R0.sR]{plot.R0.sR()}}.

This is a wrapper function that will call the correct plotting routine
depending on which method was used to estimate a reproduction number.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
