% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{qq_statistics}
\alias{qq_statistics}
\title{Summary Statistics for QQ Regression}
\usage{
qq_statistics(qq_result, alpha = 0.05)
}
\arguments{
\item{qq_result}{An object of class "qq_regression".}

\item{alpha}{Numeric. Significance level for counting significant results.
Default is 0.05.}
}
\value{
A data frame with summary statistics including:
\itemize{
  \item Mean, median, min, max of coefficients
  \item Mean, median, min, max of R-squared
  \item Number of significant results at specified alpha
  \item Total number of results
}
}
\description{
Computes comprehensive summary statistics for QQ regression results.
}
\examples{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

# Run QQ regression
result <- qq_regression(y, x, verbose = FALSE)

# Get summary statistics
stats <- qq_statistics(result)
print(stats)

}
