% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_qq_correlation}
\alias{plot_qq_correlation}
\title{Quantile Correlation Heatmap}
\usage{
plot_qq_correlation(
  y,
  x,
  quantiles = seq(0.1, 0.9, by = 0.1),
  x_label = "X Variable Quantiles",
  y_label = "Y Variable Quantiles",
  title = "Quantile Correlation Heatmap",
  show_annotations = TRUE
)
}
\arguments{
\item{y}{Numeric vector. The first variable.}

\item{x}{Numeric vector. The second variable.}

\item{quantiles}{Numeric vector. Quantiles to compute correlations for.
Default is \code{seq(0.1, 0.9, by = 0.1)}.}

\item{x_label}{Character string. Label for x-axis. Default is
"X Variable Quantiles".}

\item{y_label}{Character string. Label for y-axis. Default is
"Y Variable Quantiles".}

\item{title}{Character string. Plot title. Default is
"Quantile Correlation Heatmap".}

\item{show_annotations}{Logical. If \code{TRUE}, shows correlation
values as text annotations. Default is \code{TRUE}.}
}
\value{
A plotly object representing the correlation heatmap.
}
\description{
Creates an interactive heatmap showing the correlation between quantiles
of two variables. Uses a blue-red diverging color scale similar to
Python's seaborn style.
}
\details{
This function computes correlations between binary indicators of whether
observations fall below each quantile threshold. The resulting heatmap
shows how the relationship between variables varies across different
parts of their distributions.
}
\examples{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

\donttest{
# Create correlation heatmap
plot_qq_correlation(y, x)
}

}
