% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileOnQuantile-package.R
\docType{package}
\name{QuantileOnQuantile-package}
\alias{QuantileOnQuantile}
\alias{QuantileOnQuantile-package}
\title{QuantileOnQuantile: Quantile-on-Quantile Regression Analysis}
\description{
Implements the Quantile-on-Quantile (QQ) regression methodology developed 
by Sim and Zhou (2015). This approach extends standard quantile regression by 
estimates the effect that quantiles of one variable have on quantiles 
of another, capturing the full dependence structure between their distributions.
}
\details{
The main functions are:
\itemize{
  \item \code{\link{qq_regression}} - Perform QQ regression analysis
  \item \code{\link{plot_qq_3d}} - Create 3D surface plots (MATLAB-style)
  \item \code{\link{plot_qq_heatmap}} - Create heatmap visualizations
  \item \code{\link{plot_qq_contour}} - Create contour plots
  \item \code{\link{plot_qq_correlation}} - Create quantile correlation 
    heatmaps
}

The package provides multiple color scales:
\itemize{
  \item Jet - MATLAB-style rainbow
  \item BlueRed - Diverging scale
  \item Viridis - Colorblind-friendly
  \item Plasma - High contrast
}
}
\section{Methodology}{


The QQ approach combines quantile regression with local linear regression.
For each quantile tau of the independent variable and each quantile theta 
of the dependent variable, the method estimates coefficients that capture 
how the relationship varies across the distributions.

This is particularly useful for financial applications where the relationship
between variables may differ during extreme market conditions.
}

\references{
Sim, N. and Zhou, H. (2015). Oil Prices, US Stock Return, and the 
Dependence Between Their Quantiles. \emph{Journal of Banking & Finance}, 
55, 1-12. \doi{10.1016/j.jbankfin.2015.01.013}
}
\seealso{
\code{\link[quantreg]{rq}} for the underlying quantile regression function.
}
\author{
\strong{Maintainer}: Merwan Roudane \email{merwanroudane920@gmail.com} [copyright holder]

Other contributors:
\itemize{
  \item Nicholas Sim (Original methodology developer) [contributor]
  \item Hongtao Zhou (Original methodology developer) [contributor]
}

}
\keyword{internal}
