% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.opt.R
\name{q.opt}
\alias{q.opt}
\title{Estimate the optimal number of genes to construct QuEST model}
\usage{
q.opt(x, y, range = 5:50, method = "linear", rep = 1)
}
\arguments{
\item{x}{A data matrix (row: samples, col: genes).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{range}{A sequence of numbers of genes to be tested for MAE calculation (default: 5:50).}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{rep}{The number of replications for each case set by range (default: 1).}
}
\value{
A sample-MAE curve
}
\description{
Estimate the optimal number of genes to construct QuEST model
}
\examples{
data(Pinus)
train <- q.clean(Pinus$train)
target <- Pinus$target
q.opt(train[1:10, ], target[1:10], range = 5:15)
}
\author{
Takahiko Koizumi
}
