% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{pdr_estimate_k0}
\alias{pdr_estimate_k0}
\title{Estimate initial k from heavy isotope concentration data}
\usage{
pdr_estimate_k0(time, n, frac_k, quiet = FALSE)
}
\arguments{
\item{time}{Vector of numeric time values (e.g. days); first should be zero}

\item{n}{Observed heavy isotope (as a volume), same length as time}

\item{frac_k}{Fractionation: 13C consumption as a fraction of 12C consumption}

\item{quiet}{Suppress output message, logical}
}
\value{
Initial estimate of k0 (consumption rate constant)
}
\description{
Estimate initial k from heavy isotope concentration data
}
\examples{
pdr_estimate_k0(1:5, c(1, 0.9, 0.7, 0.65, 0.4), frac_k = 0.98)
}
