% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotData.R
\name{plotData}
\alias{plotData}
\title{Plot Accelerometer Data over Time}
\usage{
plotData(
  data,
  day = NULL,
  start = NULL,
  end = NULL,
  cts = getOption("pa.cts"),
  TS = getOption("pa.timeStamp"),
  summary = NULL
)
}
\arguments{
\item{data}{Data with classified wear and nonwear status from
\code{\link{wearingMarking}}.}

\item{day}{A part of data during a user specified day for plot.}

\item{start}{Define a starting time for plot.}

\item{end}{Define a ending time for plot.}

\item{cts}{The name of the counts column. The default is "axis1".}

\item{TS}{The column name for timestamp. The default is "TimeStamp".}

\item{summary}{List output of \code{\link{summaryData}} function.}
}
\value{
Plot with midnight marking.
}
\description{
This function makes plot for accelerometer collected data (counts) over time
for the whole monitor period, or a user specified time period or day with a
midnight marking to separate monitored days.
}
\details{
If a local time-zone is specified for \code{wearkingMarking}, it is possible
that daylight savings starts or ends during the period shown.  In this case
a dotted line will indicate its position and the appropriate time-zone
abbreviations will be included.
}
\examples{
data(dataSec)

mydata1m = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 60)

data1m = wearingMarking(dataset = mydata1m,
                       frame = 90, 
                       perMinuteCts = 1,
                       TS = "TimeStamp",
                       cts = "counts", 
                       streamFrame = NULL, 
                       allowanceFrame= 2, 
                       newcolname = "wearing")

## change "cts" default from "axis1" to "counts"
options(pa.cts = "counts")
## plot the whole data
plotData(data=data1m)

## plot the data from 60 min to 900 min
plotData(data=data1m, start=60, end=900)

## plot the data for day 2
plotData(data=data1m, day=2)

## include summaryData
sumdat <- summaryData(data=data1m)
plotData(data=data1m, summary=sumdat)

## present daylight saving time change
data(deliveryData)
options(pa.cts = "vm")
wm <- wearingMarking(dataset = deliveryData, TS="TimeStamp", tz="America/Chicago")
sumdat <- summaryData(wm)
plotData(data=wm, summary = sumdat)
## valid data after delivery marking
del <- markDelivery(wm)
sumdat <- summaryData(wm, delivery = del)
plotData(data=wm, summary = sumdat)
}
\seealso{
\code{\link{wearingMarking}}, \code{\link{sumVct}}, \code{\link{summaryData}}
}
\author{
Leena Choi \email{leena.choi@Vanderbilt.Edu}
}
