% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{pinguinos_df}
\alias{pinguinos_df}
\title{Penguin Heart Rate}
\format{
A data frame with 24 observations and 2 variables:
\describe{
  \item{group}{Penguin group (factor with 3 levels: "breeding female", "breeding male", "nonbreeding female").}
  \item{slope}{Slope of the regression of mass-specific metabolic rate on heart rate (numeric).}
}
}
\source{
Data taken from the abd package version 0.2-8
}
\usage{
data(pinguinos_df)
}
\description{
This dataset, pinguinos_df, is a data frame containing the slopes of regressions
of mass-specific metabolic rate on heart rate for three groups of Macaroni Penguins.
The data summarize physiological relationships between metabolic and cardiac activity
under different breeding and sex conditions.
}
\details{
The dataset includes one factor variable indicating the penguin group and one numeric
variable representing the slope of the regression for each observation.
Some observations may contain missing values.

The dataset name has been kept as 'pinguinos_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PenguinR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
