% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_spec_test.R
\name{psw.spec.test}
\alias{psw.spec.test}
\title{Propensity score model specification test}
\usage{
psw.spec.test(data, form.ps, weight, V.name, trans.type, K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, and \code{"TRAPEZOIDAL"}.
Note that specification test is not available for \code{weight = "OVERLAP"}.}

\item{V.name}{a vector of covariates on which the specification test is performed.}

\item{trans.type}{a vector of the same length as \code{V.name} that specifies the transformation type for each element in \code{V.name}.
Available transformations are \code{"identity"}, \code{"log"}, \code{"logit"}, \code{"sqrt"}, and \code{"Fisher"}.
No transformation is perfomred with \code{"identity"}.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight. \code{K=4} by default.}
}
\value{
A list of model specification test results.
\item{weight}{weighting method.}
\item{ps.model}{object returned by fitting the propensity score model using \code{glm} with \code{"binomial"} family.}
\item{ps.hat}{estimated propensity score.}
\item{W}{estimated propensity score weight.}
\item{V.name}{covariates in the specification test.}
\item{g.B1.hat}{a vector of transformed weighted average for covariates in the treated group when \code{spec.test=T}.}
\item{g.B0.hat}{a vector of transformed weighted average for covariates in the control group when \code{spec.test=T}.}
\item{B.hat}{difference between \code{eta.B1.hat} and \code{eta.B0.hat} when \code{spec.test=T}.}
\item{var.B.hat}{covariance matrix for \code{B.hat} when \code{spec.test=T}.}
\item{test.stat}{test statistic for the specification test, which follows the \eqn{\chi^2_{df}} distribution under the null, available when \code{spec.test=T}.}
\item{df}{degree of freedom for the specification test, \code{df=rank(var.B.hat)}, available when \code{spec.test=T}.}
\item{pvalue}{pvalue of the specification test when \code{spec.test=T}.}
}
\description{
\code{psw.spec.test} is used to test the sufficiency of propensity score model in balancing covariates between groups.
}
\details{
In the data set, treatment indicator should be numerically specified such that a value of \code{1} indicates the treated
and a value of \code{0} indicates the control. The null hypothesis is that the propensity score model is correctly specified; the
alternative is that the propensity score model is misspecified. Therefore, this test is a goodness-of-fit test of propensity score model,
with the test statistic being a metric of covariate balance.
#'
  Rejection of the specification test implies current propensity score model is inadquate
for balancing covariates between groups.
}
\examples{
# Load the test data set
data(test_data);
# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";
# A vector of covariates
V.name <- c( "X1", "X2", "X3", "X4" );
# A vector of transformation types for covariates in V.name.
trans.type <- c( "identity", "identity", "logit", "logit" );
tmp <- psw.spec.test( data = test_data, form.ps = form.ps,
weight = "MW", V.name = V.name, trans.type = trans.type );

}
\seealso{
\link{psw}, \link{psw.balance}
}
