% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contingency.R
\name{contingency}
\alias{contingency}
\title{Contingency Calculation.}
\usage{
contingency(sims, phigh = 0.95, pbase = 0.5)
}
\arguments{
\item{sims}{List of results from a Monte Carlo simulation.}

\item{phigh}{Percentile level for contingency calculation. Default is 0.95.}

\item{pbase}{Base level for contingency calculation. Default is 0.5}
}
\value{
The function returns the value of calculated contingency.
}
\description{
Contingency Calculation.
}
\examples{
# Set the number os simulations and the task distributions for a toy project.
num_sims <- 10000
task_dists <- list(
  list(type = "normal", mean = 10, sd = 2),  # Task A: Normal distribution
  list(type = "triangular", a = 5, b = 10, c = 15),  # Task B: Triangular distribution
  list(type = "uniform", min = 8, max = 12)  # Task C: Uniform distribution
)

# Set the correlation matrix for the correlations between tasks.
cor_mat <- matrix(c(
  1, 0.5, 0.3,
  0.5, 1, 0.4,
  0.3, 0.4, 1
), nrow = 3, byrow = TRUE)

# Run the Monte Carlo simulation.
results <- mcs(num_sims, task_dists, cor_mat)

# Calculate the contingency and print the results.
contingency <- contingency(results, phigh = 0.95, pbase = 0.50)
cat("Contingency based on 95th percentile and 50th percentile:", contingency)
}
