% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLoS.R
\name{SLoS}
\alias{SLoS}
\title{SLoS regression Model}
\usage{
SLoS(
  Y,
  X,
  M,
  d,
  domain,
  extra = list(Maxiter = 100, lambda = exp(seq(-20, -12, length.out = 10)), gamma =
    10^(-9:0), absTol = 10^(-10), Cutoff = 10^(-6))
)
}
\arguments{
\item{Y}{Vector, length n, centred response.}

\item{X}{Matrix of n x p, covariate matrix, should be dense, centred.}

\item{M}{Integer, t1,..., tM are M equally spaced knots.}

\item{d}{Integer, the degree of B-Splines.}

\item{domain}{The range over which the function X(t) is evaluated and the coefficient function \eqn{\beta}(t) is expanded by the B-spline basis functions.}

\item{extra}{List of parameters which have default values:
\itemize{
  \item Maxiter: Maximum number of iterations for convergence of beta, default is 100.
  \item lambda: Positive number, tuning parameter for fSCAD penalty, default is exp(seq(-20,-12, length.out = 10)).
  \item gamma: Positive number, tuning parameter for the roughness penalty, default is 10^(-9:0).
  \item absTol: Number, if max(norm(bHat)) is smaller than absTol, we stop another iteration, default is 10^(-10).
  \item Cutoff: Number, if bHat is smaller than Cutoff, set it to zero to avoid being numerically unstable, default is 10^(-6).
}}
}
\value{
beta: Estimated \eqn{\beta}(t) at discrete points.

extra: List containing other values which may be of use:
       \itemize{
         \item X: Matrix of n x p used for model.
         \item Y: Vector of length n used for model.
         \item M: Integer representing the number of knots used in the model calculation.
         \item d: Integer, degree of B-Splines used.
         \item domain: The range over which the function X(t) was evaluated and the coefficient function \eqn{\beta}(t) was expanded by the B-spline basis functions.
         \item b: Estimated b values.
         \item delta: Estimated cutoff point.
         \item Optgamma: Optimal smoothing parameter selected by BIC.
         \item Optlambda: Optimal shrinkage parameter selected by BIC.}
}
\description{
Calculates functional regression using the Smooth and Locally Sparse (SLoS) method.
}
\examples{
library(fda)
betaind = 1
snr  = 2
nsim = 1
n    = 50
p    = 21
Y = array(NA,c(n,nsim))
X = array(NA,c(n,p,nsim))
domain = c(0,1)

M = 20
d = 3
norder   = d+1
nknots   = M+1
knots    = seq(domain[1],domain[2],length.out = nknots)
nbasis   = nknots + norder - 2
basis    = fda::create.bspline.basis(knots,nbasis,norder)
V = eval.penalty(basis,int2Lfd(2))

extra=list(lambda=exp(seq(-18,-12, length.out = 10)),gamma=10^(-8:-6))

for(itersim in 1:nsim)
{
 dat = ngr.data.generator.bsplines(n=n,nknots=64,norder=4,p=p,domain=domain,snr=snr,betaind=betaind)
  Y[,itersim]  = dat$Y
  X[,,itersim] = dat$X
}

slosfit = SLoS(Y=Y[1:n,1],(X[1:n,,1]),M=M,d=d,domain=domain,extra=extra)


}
