#' @title SP500
#'
#' @description Year-end data on the S&P 500®, Nominal GDP and Consumer Prices from 
#' 1925 to the most recent year-end for which final data is available.
#' 
#' @docType data
#'
#' @usage data(SP500)
#'
#' @format A data frame with observations on the S&P 500® from 1925 
#' to the most recent year end for which final data is available:
#' \itemize{
#'  \item \strong{Year:} type `num`.
#'  \item \strong{SP500PriceHigh:} type `num`. Highest price level achieved by the 
#'  S&P 500 during the calendar year.
#'  \item \strong{SP500PriceLow:} type `num`. Lowest price level achieved by the 
#'  S&P 500 during the calendar year.
#'  \item \strong{SP500PriceClose:} type `num`. Year-end (12/31) price of the S&P 500.
#'  \item \strong{SP500EpsAll4Q:} type `num`. As-Reported Earnings per share
#'  for the S&P 500 for the entire calendar year.
#'  \item \strong{SP500EpsBest3Q:} type `num`. 4/3 x Sum of the three highest
#'  quarterly earnings per share for the S&P 500 during the calendar year.
#'  \item \strong{SP500EpsBest2Q:} type `num`. 2 x Sum of the two highest
#'  quarterly earnings per share for the S&P 500 during the calendar year.
#'  \item \strong{SP500EpsBest1Q:} type `num`. 4 x the highest earnings per share
#'  in a quarter for the S&P 500 during the calendar year.
#'  \item \strong{SP500RevenuePS:} type `num`. Annual Revenues per share 
#'  for the S&P 500 during the calendar year.
#'  \item \strong{SP500BookValuePS:} type `num`. Year-end (12/31) Book Value 
#'  (or Shareholders' Equity) per share for the S&P 500.
#'  \item \strong{SP500DPS:} type `num`. Dividends per share for the S&P 500 
#'  during the calendar year.
#'  \item \strong{SP500OperatingEPS:} type `num`. Operating Earnings 
#'  per share for the S&P 500 for the calendar year.
#'  \item \strong{SP500NomRet:} type `num`. Nominal total return including
#'  both change in price and dividends and not adjusted for inflation for the 
#'  S&P 500 for the current calendar year.
#'  \item \strong{SP500Nom1YrFwdRet:} type `num`. Nominal total return including
#'  both change in price and dividends and not adjusted for inflation for the 
#'  S&P 500 for the FOLLOWING calendar year. This is the same as SP500NomRet
#'  with a one year lag. It is included primarily to make it easy to build
#'  forecasting models without any need to apply a lag operator to SP500NomRet.
#'  \item \strong{CPIAUCNS:} type `num`. Consumer Price Index for All Urban 
#'  Consumers: All Items in U.S. City Average, as of year end.
#'  \item \strong{GDPA:} type `num`. Nominal GDP at an annual frequency.
#' }
#' 
#' @references
#' Chapter 13 (Expected Returns) of Martin, Philips, Scherer, Stoyanov and Li, 
#' Portfolio Construction and Risk Analysis, Springer, 2024.
#' 
#' @details
#' This dataset was constructed by combining information in various datasets, and
#' is updated annually using data published in
#' https://www.spglobal.com/spdji/en/documents/additional-material/sp-500-eps-est.xlsx. Final year-end numbers
#' Revenues per share from 1992 to 199 are taken from SP500from1967to2007,
#' and prior to this are estimated from the per-share revenues of the 
#' S&P 425 Industrials® and S&P Industrials® indices, using the procedure described in 
#' Philips, Thomas and Ural, Cenk, "Uncloaking Campbell and Shiller’s CAPE: A
#' Comprehensive Guide to its Construction and Use", Journal of Portfolio Management,
#' Vol 43, No. 1, Fall 2016, pp. 109-125.
#' 
#' @source S&P Dow Jones Indices and Federal Reserve Bank of St. Louis. 
#' S&P®, S&P 400 Industrials®, S&P 425 Industrials®, S&P Industrials®and S&P 500® 
#' are registered trademarks of Standard & Poor’s Financial Services LLC, 
#' and Dow Jones® is a registered trademark of Dow Jones Trademark Holdings LLC. 
#' © 2023 S&P Dow Jones Indices LLC, #' its affiliates and/or its licensors. 
#' All rights reserved.
#' Redistribution of the data is not permitted, and use of the data in
#' derivative works is not permitted without the written permission of 
#' S&P Dow Jones Indices LLC. Data for the S&P 500® is updated using the QUARTERLY DATA tab of
#' https://www.spglobal.com/spdji/en/documents/additional-material/sp-500-eps-est.xlsx. 
#' Final year-end numbers are typically reported in April or May of the following year.
#' CPIAUCNS is obtained from the Federal Reserve Bank of St. Louis' FRED database at 
#' https://fred.stlouisfed.org/series/CPIAUCNS. 
#' GDPA is obtained from the Federal Reserve Bank of St. Louis' FRED database at 
#' https://fred.stlouisfed.org/series/GDPA. 
#' 
#' @examples  
#' data(SP500)
#' names(SP500)
#' head(SP500, 5)
#' tail(SP500, 5)
"SP500"