
test_that("is_restrictedDAG works", {

  DAG = create_empty_DAG(4)
  DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
  DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

  # 1 active cycle
  expect_false(is_restrictedDAG(DAG, verbose = FALSE))
  # Now no active cycle
  DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
  expect_true(is_restrictedDAG(DAG, verbose = FALSE))

  DAG = create_empty_DAG(5)
  DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

  DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

  # There is one interfering v-structure
  expect_false(is_restrictedDAG(DAG, verbose = FALSE))

  DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
  # Now no interfering v-structure
  expect_true(is_restrictedDAG(DAG, verbose = FALSE))
})

test_that("DAG_to_restrictedDAG works", {

  # DAG with active cycle
  DAG = create_empty_DAG(5)
  DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U5')
  DAG = bnlearn::set.arc(DAG, 'U4', 'U5')

  fixed_DAG = DAG_to_restrictedDAG(DAG)

  # Fixed graph should have extra arcs 1 -> 5, 2 -> 5
  expected_DAG = DAG
  expected_DAG = bnlearn::set.arc(expected_DAG, 'U2', 'U5')
  expected_DAG = bnlearn::set.arc(expected_DAG, 'U1', 'U5')

  false_positives = bnlearn::compare(expected_DAG, fixed_DAG)$fp
  false_negatives = bnlearn::compare(expected_DAG, fixed_DAG)$fn

  expect_identical(false_positives + false_negatives, 0)

  # DAG with an interfering v-structures node 3
  DAG = create_empty_DAG(5)
  DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

  fixed_DAG = DAG_to_restrictedDAG(DAG)

  # Fixed graph should have extra arcs 1 -> 5
  expected_DAG = DAG
  expected_DAG = bnlearn::set.arc(expected_DAG, 'U1', 'U5')

  false_positives = bnlearn::compare(expected_DAG, fixed_DAG)$fp
  false_negatives = bnlearn::compare(expected_DAG, fixed_DAG)$fn

  expect_identical(false_positives + false_negatives, 0)
})


test_that("DAG_to_restrictedDAG works with complicated graph", {

  DAG = create_empty_DAG(8)
  DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
  DAG = bnlearn::set.arc(DAG, 'U1', 'U7')

  DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U6')

  DAG = bnlearn::set.arc(DAG, 'U3', 'U5')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U6')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U7')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U8')

  DAG = bnlearn::set.arc(DAG, 'U4', 'U6')
  DAG = bnlearn::set.arc(DAG, 'U4', 'U8')

  DAG = bnlearn::set.arc(DAG, 'U6', 'U7')
  DAG = bnlearn::set.arc(DAG, 'U6', 'U8')

  find_B_sets(DAG)$nodes_with_inter_vs

  fixed_DAG = DAG_to_restrictedDAG(DAG)

  expect_false(find_B_sets(fixed_DAG)$has_interfering_vstrucs)
  expect_true(is_restrictedDAG(fixed_DAG, verbose = 0, check_both = FALSE))
} )


test_that("fix_interfering_vstructs works in a simple case", {

  DAG = create_empty_DAG(5)
  DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U1', 'U5')

  DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
  DAG = bnlearn::set.arc(DAG, 'U2', 'U4')

  DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
  DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

  all_B_sets = find_B_sets(DAG)
  all_B_sets$nodes_with_inter_vs

  fixed_DAG = fix_interfering_vstructs(DAG, all_B_sets)

  expect_false(find_B_sets(fixed_DAG)$has_interfering_vstrucs)
} )
