\name{OnomasticDiversity-package}
\alias{OnomasticDiversity-package}
\alias{OnomasticDiversity}
\docType{package}
\title{
\packageTitle{OnomasticDiversity}
}
\description{
\packageDescription{OnomasticDiversity}
}
\details{

The DESCRIPTION file:
\packageDESCRIPTION{OnomasticDiversity}
\packageIndices{OnomasticDiversity}
This package computes the different measures which can be used to quantify similarities between regions. These measures are isonymy, isonymy between, Lasker distance, coefficients of Hedrick and Nei.
A diversity index is a numerical measure of how many different types (such as species) are present in a dataset (a community), as well as the evolutionary relationships among the individuals distributed throughout those types, such as richness, divergence, and evenness. These indicators are numerical representations of biodiversity in several dimensions (richness, evenness, and dominance). Then, this package calculates biodiversity indices such as Margalef, Menhinick, Simpson, Shannon, Shannon-Wiener Sheldon, Heip, Hill Numbers, Geometric Mean and Cressie and Read statistics.
}
\author{
\packageAuthor{OnomasticDiversity}

Maintainer: \packageMaintainer{OnomasticDiversity}
}
\references{
Buckland, S.T., Studeny, A.C., Magurran, A.E., Illian, J.B., & Newson, S.E.  (2011). The geometric mean of relative abundance indices: a biodiversity measure with a difference. \emph{Ecosphere}, \bold{2}(9), art.100. <https://doi.org/10.1890/ES11-00186.1>

Cressie, Noel and Read, Timothy RC (1984) Multinomial goodness-of-fit tests. \emph{Computational Statistics and Data Analysis}, \bold{46}(3), 440--464. <http://www.jstor.org/stable/2345686>

Sheldon, A. L. (1969). Equitability indices: dependence on the species count. \emph{Ecology}, \bold{50}, 466--467. <https://doi.org/10.2307/1933900>

Simpson (1949) Measurement of diversity. \emph{Nature}, \bold{163}. <https://doi.org/10.1038/163688a0>

Studeny, A.C. (2012). \emph{Quantifying Biodiversity Trends in Time and Space}. PhD thesis, University of St Andrews. <https://research-repository.st-andrews.ac.uk/bitstream/handle/10023/3414/AngelikaStudenyPhDThesis.pdf?sequence=3&isAllowed=y>

van Strien, A.J., Soldaat, L.L., & Gregory, R.D. (2012). Desirable mathematical properties of indicators for biodiversity change. \emph{Ecological Indicators}, \bold{14}, 202--208. <https://doi.org/10.1016/j.ecolind.2011.07.007>
}

\keyword{OnomasticDiversity}

\seealso{
\code{\link{fCressieRead}},
\code{\link{fGeneralisedMean}},
\code{\link{fGeometricMean}},
\code{\link{fHeip}},
\code{\link{fHill}},
\code{\link{fIsonymy}},
\code{\link{fIsonymyAll}},
\code{\link{fMargalef}},
\code{\link{fMenhinick}},
\code{\link{fPielou}},
\code{\link{fShannon}}, 
\code{\link{fSheldon}}, 
\code{\link{fSimpson}},
\code{\link{fSimpsonInf}}, \code{\link{fGeneralisedMean}}, \code{\link{fHeip}}}