% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ProstateSurgery_df}
\alias{ProstateSurgery_df}
\title{Prostate Cancer Surgery Study}
\format{
A data frame with 97 observations and 9 variables:
\describe{
  \item{lcavol}{Logarithm of cancer volume (numeric).}
  \item{lweight}{Logarithm of prostate weight (numeric).}
  \item{age}{Patient's age in years (integer).}
  \item{lbph}{Logarithm of the amount of benign prostatic hyperplasia (numeric).}
  \item{svi}{Seminal vesicle invasion (binary: 0 = No, 1 = Yes; integer).}
  \item{lcp}{Logarithm of capsular penetration (numeric).}
  \item{gleason}{Gleason score (integer).}
  \item{pgg45}{Percentage of Gleason scores 4 or 5 (integer).}
  \item{lpsa}{Logarithm of prostate-specific antigen (PSA) level (numeric).}
}
}
\source{
Data taken from the faraway package.
}
\usage{
data(ProstateSurgery_df)
}
\description{
This dataset, ProstateSurgery_df, is a data frame containing data from a study on 97 men with prostate cancer who were scheduled to undergo radical prostatectomy. The dataset includes clinical and pathological variables associated with prostate cancer.
}
\details{
The dataset name has been kept as 'ProstateSurgery_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
