% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{Metadata}
\usage{
get_metadata(buildings, selection, verbose = TRUE)
}
\arguments{
\item{buildings}{Integer, character, or vectors of those types, providing building id(s) or name(s). You can provide multiple buildings at once.}

\item{selection}{Selection list from point selector.}

\item{verbose}{Logical. If TRUE (default), print status messages.}
}
\value{
A data.frame of clean metadata for the requested points.
}
\description{
Retrieves points and equipment for a given building or selection and outputs a clean metadata data.frame.
}
\examples{
\dontrun{
metadata <- get_metadata(buildings=c(427,"Laboratory"))

OR

query <- PointSelector()

query$buildings <- 427
query$equipment_types <- 'ahu'
query$point_types <- c('Supply Air Temperature','Supply Air Static Pressure')

selection <- select_points(query)

metadata <- get_metadata(selection)
}

}
