% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_matrices.R
\name{make_PCs_irlba}
\alias{make_PCs_irlba}
\title{Run Principal Component Analysis (PCA) using the irlba package.}
\usage{
make_PCs_irlba(X, n.top = 2)
}
\arguments{
\item{X}{A correlation matrix.}

\item{n.top}{Number of top principal compenents to return}
}
\value{
A matrix of Principal Components of dimension (# of samples) x
  (n.top). As expected, eigenvectors are ordered by eigenvalue. Rownames
  are given as sample IDs.
}
\description{
A simple wrapper around the irlba() function which computes a partial SVD
efficiently. This function's run time depends on the number of eigenvectors
requested but scales well. Use this function to generate covariates for use
with the \code{\link{okriging}} or \code{\link{krigr_cross_validation}}
functions.
}
\examples{
 ## compute PC's using the  gene expression correlation matrix from vignette
 ## load gene expression values from vignette
 expressionFile <- system.file(package = "OmicKriging",
                     "doc/vignette_data/ig_gene_subset.txt.gz")
 ## compute correlation matrix
 geneCorrelationMatrix <- make_GXM(expressionFile)
 ## find top ten PC's of this matrix using SVD
 topPcs <- make_PCs_irlba(geneCorrelationMatrix, n.top=10) 
}
\references{
library(irlba)
}
\keyword{GRM}
\keyword{PCA,}
\keyword{covariate,}

