% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{area}
\alias{area}
\title{A function to compute the spatial units' areas}
\usage{
area(spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{spatobj}{a spatial object (class sf, sfc or sfg) containing 
geographic information}

\item{folder}{a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}
}
\value{
A vector containing the areas of spatial units
}
\description{
The function is based on \pkg{sf} package and can be 
used with a shape file or an R spatial object (class sf, sfc or sfg).
}
\examples{
 area(segdata) 
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'
area(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices 
computation: \code{\link{contig}}, \code{\link{perimeter}}, 
\code{\link{distance}}, \code{\link{distcenter}}, 
\code{\link{boundaries}}
}
