% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_ORFID.R
\name{export_ORFID}
\alias{export_ORFID}
\title{Export compiled data from Oregon RFID antenna readers}
\usage{
export_ORFID(x, name, extension)
}
\arguments{
\item{x}{data frame to be exported.}

\item{name}{file name.}

\item{extension}{file extension (".csv" or ".xlsx").}
}
\value{
A file is saved to the working directory.
}
\description{
Data compiled using \code{\link{import_ORFID}} or \code{\link{join_multireader_data}} are exported to the working directory as either a .csv or .xlsx file
}
\details{
Any data frame created using functions in the \pkg{ORFID} package can be exported using this function.
}
\seealso{
\code{\link{import_ORFID}} for importing data files from Oregon RFID ORMR and ORSR antenna readers.

\code{\link{join_multireader_data}} for combining data from Oregon RFID ORMR and ORSR antenna readers into a multi-reader array.
}
\author{
Hugo Marques <biohmarques@gmail.com>
}
