% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisLomax.r
\name{LogisLomax}
\alias{LogisLomax}
\alias{dlogis.lomax}
\alias{plogis.lomax}
\alias{qlogis.lomax}
\alias{rlogis.lomax}
\alias{hlogis.lomax}
\title{Logistic-Lomax Distribution}
\usage{
dlogis.lomax(x, alpha, beta, lambda, log = FALSE)
plogis.lomax(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.lomax(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.lomax(n, alpha, beta, lambda)
hlogis.lomax(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.lomax}: numeric vector of (log-)densities
  \item \code{plogis.lomax}: numeric vector of probabilities
  \item \code{qlogis.lomax}: numeric vector of quantiles
  \item \code{rlogis.lomax}: numeric vector of random variates
  \item \code{hlogis.lomax}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Lomax distribution.
}
\details{
The Logistic-Lomax distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-Lomax distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1 - \frac{1}{{1 + {{\left( {{{(1 + \beta x)}^\lambda } - 1} \right)}
^\alpha }}}\quad ;\,x \geqslant 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlogis.lomax()} — Density function
  \item \code{plogis.lomax()} — Distribution function
  \item \code{qlogis.lomax()} — Quantile function
  \item \code{rlogis.lomax()} — Random generation
  \item \code{hlogis.lomax()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dlogis.lomax(x, 1.5, 0.1, 2.0)
plogis.lomax(x, 1.5, 0.1, 2.0)
qlogis.lomax(0.5, 1.5, 0.1, 2.0)
rlogis.lomax(10, 1.5, 0.1, 2.0)
hlogis.lomax(x, 1.5, 0.1, 2.0)

# Data
x <- bladder
# ML estimates
params = list(alpha=1.38027, beta=0.04451, lambda=2.80412)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.lomax, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.lomax, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
      dfun = dlogis.lomax, pfun=plogis.lomax, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K., & Kumar, V.(2020). 
The Logistic Lomax Distribution with Properties and Applications. 
\emph{International Journal of New Technology and Research}, 
\bold{6(12)}, 74--80. \doi{10.31871/IJNTR.6.12.21} 

Shrestha, S.K., & Kumar, V. (2014). 
Bayesian Analysis of Extended Lomax Distribution. \emph{International 
Journal of Mathematical Trends and Technology (IJMTT)}, \bold{7(1)}, 33--41.  
\doi{10.14445/22315373/IJMTT-V7P505}
}
