% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\name{neighbors}
\alias{neighbors}
\alias{neighbors,worldNLR,matrix,numeric-method}
\title{Neighbors \code{patches}}
\usage{
neighbors(world, agents, nNeighbors, torus = FALSE)

\S4method{neighbors}{worldNLR,matrix,numeric}(world, agents, nNeighbors, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{nNeighbors}{Integer: 4 or 8. Represents the number of neighbor \code{patches}
considered.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (\code{ncol} = 3) with the first column \code{pxcor}
and the second column \code{pycor} representing the coordinates of the neighbors
\code{patches} around the \code{agents} and the third column \code{id} representing
the \code{id} of the \code{agents} in the order provided.
}
\description{
Report the coordinates of the neighbors \code{patches} around the \code{agents}.
}
\details{
The \code{patch} around which the neighbors are identified, or the \code{patch} where
the \code{turtle} is located on around which the neighbors are identified, is not
returned.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If `torus = FALSE`, `agents` located on the edges of the
     `world` have less than `nNeighbors` patches around them.
     If `torus = TRUE`, all `agents` located on the edges of the
     `world` have `nNeighbors` patches around them,
     which some may be on the other sides of the `world`.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
if (requireNamespace("SpaDES.tools", quietly = TRUE)) {
  neighbors(world = w1, agents = patch(w1, c(0, 9), c(0, 7)), nNeighbors = 8)
  t1 <- createTurtles(n = 3, coords = randomXYcor(w1, n = 3))
  neighbors(world = w1, agents = t1, nNeighbors = 4)
}

}
\references{
Wilensky, U. 1999. NetLogo. \url{https://www.netlogo.org}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#neighbors}
}
\author{
Sarah Bauduin
}
