% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmExportToPDF}
\alias{chmExportToPDF}
\title{Export a PDF of the NGCHM to a file.}
\usage{
chmExportToPDF(
  chm,
  filename,
  overwrite = FALSE,
  shaidyMapGen,
  shaidyMapGenJava,
  shaidyMapGenArgs
)
}
\arguments{
\item{chm}{The NGCHM to generate the PDF for}

\item{filename}{The file in which to save the PDF}

\item{overwrite}{Overwrite file iff true (default false)}

\item{shaidyMapGen}{Path to shaidyMapGen jar file (default to value of environment variable SHAIDYMAPGEN)}

\item{shaidyMapGenJava}{Path to java executable with which to run shaidyMapGen (default to value of environment variable SHAIDYMAPGENJAVA or java)}

\item{shaidyMapGenArgs}{Additional arguments to pass to java when running shaidyMapGen (default to value of environment variable SHAIDYMAPGENARGS)}
}
\value{
filename
}
\description{
Create a PDF of the NGCHM in the specified file.
This function requires \strong{Java 11} and the
\strong{\href{https://github.com/MD-Anderson-Bioinformatics/NGCHMSupportFiles}{NGCHMSupportFiles}} package.
}
\details{
The NGCHMSupportFiles package can be installed from the R-universe repository: \cr\cr
\code{install.packages('NGCHMDemoData', } \cr
\code{repos = c('https://md-anderson-bioinformatics.r-universe.dev',} \cr
\code{'https://cloud.r-project.org'))}
}
