% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nblda.R, R/zzz_methods.R
\name{plot}
\alias{plot}
\alias{plot.nblda}
\alias{plot.nblda_trained}
\alias{plot,nblda-method}
\alias{plot,nblda_trained-method}
\title{Plot Method for the \code{nblda} and \code{nblda_trained} Classes}
\usage{
\method{plot}{nblda}(
  x,
  y,
  ...,
  theme = c("nblda", "default"),
  metric = c("accuracy", "error", "sparsity"),
  return = c("plot", "aes")
)

\method{plot}{nblda_trained}(
  x,
  y,
  ...,
  theme = c("nblda", "default"),
  metric = c("accuracy", "error", "sparsity"),
  return = c("plot", "aes")
)

\S4method{plot}{nblda}(
  x,
  y,
  ...,
  theme = c("nblda", "default"),
  metric = c("accuracy", "error", "sparsity"),
  return = c("plot", "aes")
)

\S4method{plot}{nblda_trained}(
  x,
  y,
  ...,
  theme = c("nblda", "default"),
  metric = c("accuracy", "error", "sparsity"),
  return = c("plot", "aes")
)
}
\arguments{
\item{x}{a \code{nblda} object returned from the \code{\link{trainNBLDA}} or \code{nblda_trained} object returned from the \code{\link{nbldaTrained}}.}

\item{y}{same as \code{x} and not required to be defined. If \code{x} is missing or NULL, \code{nblda} or \code{nblda_trained} object is imported from \code{y}.}

\item{...}{further arguments to be passed to plotting function \code{\link[ggplot2]{ggplot}}.}

\item{theme}{pre-defined plot themes. It can be defined outside \code{plot} function using the ggplot's library. See examples.}

\item{metric}{which metric should be used in the y-axis?}

\item{return}{should a complete plot or a ggplot object from \code{ggplot} be returned? One may select "aes" in order to add plot layers to a returned ggplot aesthetics. See examples.}
}
\value{
A list of class \code{ggplot}.
}
\description{
This function is used to generate model performance plots using \code{\link[ggplot2:ggplot]{ggplot2}} functions.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 10, K = 2, param = 1, sdsignal = 0.5,
                            DE = 0.8, allZero.rm = FALSE, tag.samples = TRUE)
x <- t(counts$x + 1)
y <- counts$y
xte <- t(counts$xte + 1)
ctrl <- nbldaControl(folds = 2, repeats = 2)

fit <- trainNBLDA(x = x, y = y, type = "mle", tuneLength = 10,
                  metric = "accuracy", train.control = ctrl)

plot(fit)

# Use pre-defined theme
plot(fit, theme = "nblda")

# Externally defining plot theme
plot(fit, theme = "default") + theme_dark(base_size = 14)

# Return empty ggplot object and add layers.
plot(fit, theme = "nblda", return = "aes") +
  geom_point() + geom_line(linetype = 2)

}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
\author{
Dincer Goksuluk
}
