% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spendingfun.r
\name{spendingfun}
\alias{spendingfun}
\title{Calculate alpha spending function}
\usage{
spendingfun(alpha, fractions = seq(0.2, 1, by = 0.2), family = "OBF", rho = 1)
}
\arguments{
\item{alpha}{Numeric scalar of the overall alpha to be spent.}

\item{fractions}{Numeric vector of the sequence of  information fractions.
All elements should be between 0 and 1 with the last one being exactly 1.}

\item{family}{Character scalar for the family of spending functions, one of
\code{"OBF"}, \code{"pocock"}, \code{"power"}.}

\item{rho}{Numeric scalar of auxiliary parameter for O'Brien-Fleming and
power family.}
}
\value{
List with an element named \code{aseq} for the alpha spending sequence.
}
\description{
\code{spendingfun()} calculates the alpha spending function.
}
\details{
\itemize{
\item \code{"OBF"}: O'Brien-Fleming family; \eqn{2\{1-\Phi(\Phi^{-1}(1-\alpha/2)/t^{\rho/2})\}};
\item \code{"pocock"}: Pocock family; \eqn{\alpha \log\{1+(e-1)*t\}};
\item \code{"power"}: Power family; \eqn{\alpha*t^{\rho}}
}

Note that the OBF and Pocock spending functions are not the originally
proposed ones, they are the modified ones that closely resemble the original
versions. That being said, you might still see some differences.
}
\examples{
spendingfun(
  alpha = 0.025,
  fractions = seq(0.2, 1, by = 0.2),
  family = "OBF",
  rho = 1
)
}
\author{
Xiaodong Luo
}
\concept{alpha-spending}
\concept{group-sequential}
