% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.r
\name{stats.morpho}
\alias{stats.morpho}
\title{Calculates statistics for a morpho object}
\usage{
stats.morpho(data)
}
\arguments{
\item{data}{A morpho object}
}
\value{
A list with three elements:
  - \code{Statistics}: data.frame with CI and RI
  - \code{Convergent_Traits}: data.frame listing convergent traits
  - \code{Tree}: data.frame summarizing extant/extinct tips and sampled ancestors
}
\description{
Computes three key pieces of information for a morpho object:
1. The Consistency Index (CI) and Retention Index (RI) based on the tip sequence data.
2. Convergent traits, identifying traits that have evolved independently multiple times.
3. Summary information about the size and structure of the tree.
}
\examples{
data(morpho_data)
summary <- stats.morpho(data = morpho_data)

}
