% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Categoric.R
\name{sim.categoric}
\alias{sim.categoric}
\title{Simulates Categorical Data Sets Based on a Structural Equation Model (SEM).}
\usage{
sim.categoric(
  nd = 10,
  ss = 100,
  fcors,
  loading,
  f.loc,
  threshold,
  cont = "FALSE"
)
}
\arguments{
\item{nd}{An integer, the number of data sets to be generated.}

\item{ss}{An integer, the sample size per data set (must be greater than 10).}

\item{fcors}{The factor correlation matrix, which must be symmetric. For one-factor models, this should be "matrix(1,1,1)".}

\item{loading}{The factor loading matrix. Columns correspond to factors, while non-zero rows specify the number of items associated with each factor.}

\item{f.loc}{File path indicating the directory where the generated data sets will be saved.}

\item{threshold}{Threshold values used to categorize continuous simulated data.}

\item{cont}{Logical: If TRUE, the original continuous data sets are also saved in addition to the categorical versions.}
}
\description{
This function generates categorical data sets from a specified SEM.
The simulated data are organized such that the first column represents case identifiers, while the subsequent columns contain the simulated item responses.
For example, in a model with two factors and three items per factor, the column labels will follow the format: "ID, F1_x1, F1_x2, F1_x3, F2_x1, F2_x2, F2_x3".
The number of rows corresponds to the sample number of the data.
In addition to the generated data sets, two supplementary files are also saved:
(1) "Model_Info.dat" — containing the factor correlation and factor loading matrices
(2) "Data_List.dat" — listing the names of all generated data files.
}
\examples{
fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))
tres<-c(-Inf, -1.645, -.643, .643, 1.645, Inf) # Five response categories

sim.categoric(nd=100,ss=100, fcors=fc,loading=fl, f.loc=tempdir(), threshold = tres)
}
\author{
Fatih Orçan
}
