% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.sem.sim.R
\name{fit.simulation}
\alias{fit.simulation}
\title{Fits Structural Equation Models to Simulated Data Using lavaan.}
\usage{
fit.simulation(
  model,
  PEmethod = "ML",
  Ordered = FALSE,
  dataList = "Data_List.dat",
  f.loc,
  missing = NULL
)
}
\arguments{
\item{model}{A Lavaan model}

\item{PEmethod}{The parameter estimation method. The default is ML.}

\item{Ordered}{Logical, If TRUE, variables are treated as ordered categorical; otherwise, as continuous.}

\item{dataList}{List of the names of data sets generated earlier either with the package functions or any other software.}

\item{f.loc}{File location. It indicates where the simulated data sets and "dataList" are located.}

\item{missing}{A specification for handling missing data. As in the lavaan package (See lavOptions)}
}
\description{
This function applies a pre-specified SEM model to previously generated data sets (e.g., from sim.skewed() or sim.normal()) by utilizing the lavaan package.
After model estimation, fit indices and parameter estimates with their standard errors are exported to a Comma-Separated Values (CSV) file named All_Results.csv.
Each row in this file corresponds to the results of a single simulation.
Most columns are self-explanatory; however, the second column (Notes) requires further clarification. This column indicates the convergence status of the model:
 CONVERGE – The model converged without any issues.
 NONCONVERGE – The model failed to converge; in this case, all values in the row are recorded as NA.
 WARNING – The model converged but produced warnings (e.g., negative variance estimates). Depending on the warning type, some values may be recorded as NA.
To run the simulation, previously generated data sets (either via the package functions or other software) must be stored in the same folder as the dataset list file (Data_List.dat) within the working directory.
}
\examples{

# Step 1: Generate data
fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))
sim.normal(nd=10, ss=100, fcors=fc, loading<-fl,  f.loc=tempdir())

# Step 2: Specify the model
lavaanM<-'
#CFA Model
f1	=~ NA*x1 + x2 + x3
f2	=~ NA*x4 + x5 + x6
f3 =~ NA*x7 + x8
#Factor Correlations
f1	~~ f2
f1	~~ f3
f2	~~ f3
#Factor variance
f1	~~ 1*f1
f2	~~ 1*f2
f3	~~ 1*f3
'
dl<-"Data_List.dat"  # must be available in the working directory

# Step 3: Fit the model across simulated data

fit.simulation(model=lavaanM, PEmethod="MLR", Ordered=FALSE, dataList=dl, f.loc=tempdir())

}
\author{
Fatih Orcan
}
