#' minTriadicClosure
#'
#' A smoothed triadic‐closure statistic for LOLOG models.
#'
#' @details
#' Returns a registered LOLOG change statistic that smoothly counts how many
#' nodes are in at least `triadDegree` triangles, using a smoothing parameter.
#'
#' @param triadDegree Integer threshold for triangle count.
#' @param smoothing_k Numeric smoothing parameter.
#'
#' @return A LOLOG change statistic object.
#'
#' @examples
#' registerMinTriadicClosure()  # call once to register the C++ class
#' stat <- minTriadicClosure(2, 1.5)
#' print(stat)
#'
#' @export
minTriadicClosure <- function(triadDegree, smoothing_k = 1.0) {
  registerMinTriadicClosure()
  structure(
    list(name = "minTriadicClosure", parameters = list(triadDegree, smoothing_k)),
    class = "lologChangeStatistic"
  )
}
