% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_sample.R
\name{mts_sample}
\alias{mts_sample}
\title{Sample time series for an \emph{mts} time series object}
\usage{
mts_sample(
  mts = NULL,
  sampleSize = 5000,
  seed = NULL,
  keepOutliers = FALSE,
  width = 5,
  thresholdMin = 3
)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{sampleSize}{Non-negative integer giving the number of rows to choose.}

\item{seed}{Integer passed to \code{\link[base]{set.seed}} for reproducible sampling.}

\item{keepOutliers}{Logical specifying a graphics focused sampling algorithm
that retains outliers (see Details).}

\item{width}{Integer width of the rolling window used for outlier detection.}

\item{thresholdMin}{Numeric threshold for outlier detection.}
}
\value{
A subset of the given \emph{mts} object.

An \emph{mts} time series object with fewer timesteps.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Reduce the number of records (timesteps) in the \code{data}
dataframe of the incoming \code{mts} through random sampling.
}
\details{
When \code{keepOutliers = FALSE}, random sampling is used to provide
a statistically relevant subsample of the data.
}
\section{Outlier Detection}{


When \code{keepOutliers = TRUE}, a customized sampling algorithm is used that
attempts to create subsets for use in plotting that create plots that are
visually identical to plots using all data. This is accomplished by
preserving outliers and only sampling data in regions where overplotting
is expected.

The process is as follows:
\enumerate{
\item{find outliers using \code{MazamaRollUtils::findOutliers()}}
\item{create a subset consisting of only outliers}
\item{sample the remaining data}
\item{merge the outliers and sampled data}
}

This algorithm works best when the \emph{mts} object has only one or two
timeseries.

The \code{width} and \code{thresholdMin} parameters determine the number of
outliers detected. For hourly data, a \code{width} of 5 and a \code{thresholdMin}
of 3 or 4 seem to find many visually obvious outliers.

Users attempting to optimize plotting speed for lengthy time series are
encouraged to experiment with these two parameters along with
\code{sampleSize} and review the results visually.

See \code{MazamaRollUtils::findOutliers()}.
}

