% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.mle_0.1.1.R
\name{MW.plot}
\alias{MW.plot}
\title{Plot method for Mann-Whitney effect under parametric copula models}
\usage{
MW.plot(t.event, event, group,
copula = c("clayton", "gumbel", "frank", "fgm", "gb"),
lower = 0, upper = 1,
s1 = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
s2 = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
par1 = c(0, 0),
par2 = c(0, 0),
alpha = 0.05,
logit = FALSE,
xaxis = 2
)
}
\arguments{
\item{t.event}{a vector for time-to-event.}

\item{event}{a vector for event indicator.}

\item{group}{a vector for group indicator.}

\item{copula}{copula family.}

\item{lower}{the lower end points of the interval of the copula parameter.}

\item{upper}{the lower end points of the interval of the copula parameter.}

\item{s1}{a parametric survival function for S1. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{s2}{a parametric survival function for S2. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{par1}{initial value(s) for the parameters of S1.}

\item{par2}{initial value(s) for the parameters of S2.}

\item{alpha}{significance level.}

\item{logit}{logical; if TRUE, the estimator and CI is logit-transformed.}

\item{xaxis}{a indicator specifying whether the xaxis is the copula parameter (xaxis = 1) or Kendall's tau (xaxis = 2).}
}
\value{
No return value, called for side effects (generates a plot).
}
\description{
\code{MW.plot} plots the results, the parametric estimator and their confidence intervals, for the Mann-Whitney effect under parametric survival functions and copulas.
}
\examples{
##Exponential distributions
#set distribution parameter
lambda1 = 1
lambda2 = 2

#generate time to event
u = runif(100)
t.event1 = -log(u) / lambda1
t.event1 = sort(t.event1)

v = runif(100)
t.event2 = -log(v) / lambda2
t.event2 = sort(t.event2)

#censoring indicator
t1c = runif(100, 0, 1.5)
t.event1 = (t1c >= t.event1) * t.event1 + (t1c < t.event1) * t1c
event1 = 1 * (t1c > t.event1)

t2c = runif(100, 0, 0.8)
t.event2 = (t2c >= t.event2) * t.event2 + (t2c < t.event2) * t2c
event2 = 1 * (t2c > t.event2)

t.event = c(t.event1, t.event2)
event = c(event1, event2)

#group indicator
group = rep(c(1, 0), each = 100)

MW.plot(t.event, event, group,
          copula = "clayton",
          lower = 0.2, upper = 0.8,
          s1 = "exponential", s2 = "exponential",
          par1 = c(0, 0), par2 = c(0, 0), alpha = 0.05, logit = FALSE, xaxis = 2)


}
