% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSGA3.r
\name{NSGA3}
\alias{NSGA3}
\title{Elitist Non-dominated Sorting Genetic Algorithm version III}
\usage{
NSGA3(population, fun, nObjective, control = list(), ...)
}
\arguments{
\item{population}{The parent generation. One individual per column. nrow = number of variable, ncol = number of individuals in the population.}

\item{fun}{Objective function being solved. Currently available in the package DTLZ1-DTLZ4, WFG4-WFG9.}

\item{nObjective}{The number of objective functions. A scalar value. Needed to generate weight vectors.}

\item{control}{A list, containing the following:
\code{weightVector} NSGA-III require a set of reference points defined a priori. The reference can be any point. If not supplied, 5*nObjective points are generated from a sobol sequence. Column major: nrow = nObjective, ncol = number of reference points
\code{crossoverProbability} The probability of doing crossover. Should be between 0-1. Negative value will behave like a zero, and values larger than 1 will behave like 1. Default to 1.
\code{mutationProbability} The probability of doing mutation. Should be between 0-1. Negative value will behave like a zero, and values larger than 1 will behave like 1. Default to 1
\code{mutationDistribution} The distribution index for polynomial mutation. Larger index makes the distribution sharper around the parent.
\code{crossoverDistribution} The distribution index for SBX. Larger index makes the distribution sharper around each parent.}

\item{...}{Further arguments to be passed to \code{fun}}
}
\value{
#' @return Returns a list for the next generation
\code{population} The new generation design points. Column major.
\code{populationObjective} The new generation's objective values. Column major.
}
\description{
Do an iteration of Elitist Non-dominated Sorting Genetic Algorithm version III (NSGA-III). THe variation is using SBX and polynomial mutation.
}
\examples{
nVar <- 14
nObjective <- 5
nIndividual <- 100
#control for NSGA3
ctrl <- list(crossoverProbability = 1,
             mutationProbability = 1/nVar)
#Initial population
population <- matrix(runif(nIndividual*nVar), nrow = nVar)

# run a generation of NSGA-III with standard WFG8 test function.
NSGA3(population, WFG8,nObjective,ctrl,nObjective)
}
\references{
Deb, K., Jain, H.: An evolutionary many-objective optimization algorithm using
reference-point-based  nondominated  sorting  approach,  part  I:  Solving  problems with box constraints.
Trans. Evol. Comp. 18 (4), 577–601 (2014)
}
