% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPerm.R
\name{plotPerm}
\alias{plotPerm}
\title{Plot for comparison of actual model fitness vs permutation/resampling}
\usage{
plotPerm(
  actual,
  distribution,
  xlab = NULL,
  side = c("greater", "smaller"),
  type = "t",
  ylab = NULL,
  xlim,
  ylim = NULL,
  breaks = "Sturges",
  pos,
  main = NULL,
  permutation_visual = "none",
  curve = TRUE,
  extend = 0.1,
  multiple_p_shown = NULL,
  show_actual_value = TRUE,
  show_p = TRUE,
  round_number = 4
)
}
\arguments{
\item{actual}{Actual model fitness (e.g. Q2, AUROC or number of misclassifications)}

\item{distribution}{Null hypothesis (permutation) distribution of similar metric as `actual`}

\item{xlab}{Label for x-axis (e.g. 'Q2 using real value',"Q2 using distributions","BER" 'AUROC', or 'Misclassifications')}

\item{side}{Cumulative p either "greater" or "smaller" than H0 distribution (defaults to side of median(H0))}

\item{type}{c('t','non',"smooth","rank","ecdf")}

\item{ylab}{label for y-axis}

\item{xlim}{Choice of user-specified x-limits (if default is not adequate)}

\item{ylim}{Choice of user-specified y-limits (if default is not adequate)}

\item{breaks}{Choice of user-specified histogram breaks (if default is not adequate)}

\item{pos}{Choice of position of p-value label (if default is not adequate)}

\item{main}{Choice of user-specified plot title}

\item{permutation_visual}{choice of showing median or mean or none}

\item{curve}{if add curve or not base on the mid}

\item{extend}{how many percenrtage of the orignical range do we start}

\item{multiple_p_shown}{show many p values}

\item{show_actual_value}{show the actual value on the vertical line or not}

\item{show_p}{if p value is added to the figure}

\item{round_number}{How many digits does it keep}
}
\value{
Plot
}
\description{
Plots histogram of null hypothesis (permutation/resampling) distribution, actual model fitness and cumulative p-value.
Plot defaults to "greater than" or "smaller than" tests and cumulative probability in Student's t-distribution.
}
\examples{
data("freelive2")
actual <- sample(YR2, 1)
distribution <- YR2
plotPerm (actual, distribution)
}
