% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstats.R
\name{Get_UV_from_data}
\alias{Get_UV_from_data}
\title{Compute the summary statistics given the individual-level data}
\usage{
Get_UV_from_data(traits, covariates, genotype, covariance = TRUE)
}
\arguments{
\item{traits}{a numeric list, each sublist containing trait information for each study. In each study, a numeric \eqn{n \times K} matrix with each row as an independent individual and each column as a separate trait. If subject \eqn{i} is without trait \eqn{k}, the corresponding value is set as NA. The number of traits in each study can be different but the names of traits are required.}

\item{covariates}{a numeric list, each sublist containing covariates information for each study. In each study, a numeric \eqn{n \times D} matrix with each row as an independent individual and each column as a covariate.}

\item{genotype}{a numeric list, each sublist containing genotype information for each study. In each study, a numeric \eqn{n \times m} matrix with each row as an independent individual and each column as a SNP Each genotype should be coded as 0, 1, 2, and NA for AA, Aa, aa, and missing, where A and a represents a major and minor allele, respectively. The number of SNPs in each study can be different but the names of SNPs are required. Also, the number of studies must be the same in genotype, covariates and traits lists. The order of subject ID must be the same among traits, covariates, and genotype within each study.}

\item{covariance}{a logical value indicating whether to calculate the covariance matrix of score summary statistics \eqn{U}. The default value is TRUE. If covariance is set as FALSE, then only the diagonal values of the covairance matrix are calculated, which is faster. In estimating the zeta matrix correcting for overlap samples, we recommend set covariance as FALSE in calculating the summary statistics for common variants. Since the number of common variants may be large and time-consuming.}
}
\value{
A list containing summary statistics for each trait. If covariance is TRUE, the score summary statistics \eqn{U} and its covariance matrix \eqn{V} are returned. Otherwise, only \eqn{U} and the diagonal elements of covariance matrix  are returned.
}
\description{
This function allows you to calculate the score summary statistics \eqn{U} and their covariance matrix \eqn{V} for MTAR, given the traits, covariates and genotype data sets. If one trait only takes no more than two values, this function will treat this trait as a binary trait.
}
\examples{
data(rawdata)
attach(rawdata)
obs.stat <- Get_UV_from_data(traits = traits.dat,
                             covariates = cov.dat,
                             genotype = geno.dat,
                             covariance = TRUE)
obs.stat
detach(rawdata)
}
\references{
Hu, Y.J., Berndt, S.I., Gustafsson, S., Ganna, A., Mägi, R., Wheeler, E., Feitosa, M.F., Justice, A.E., Monda, K.L., Croteau-Chonka, D.C. and Day, F.R., 2013. Meta-analysis of gene-level associations for rare variants based on single-variant statistics. The American Journal of Human Genetics, 93(2), pp.236-248.

Tang, Z.Z. and Lin, D.Y., 2015. Meta-analysis for discovering rare-variant associations: statistical methods and software programs. The American Journal of Human Genetics, 97(1), pp.35-53.
}
\author{
Lan Luo
}
