% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDEseq.R
\name{CDEseq}
\alias{CDEseq}
\title{Identification of confirmed and sequential disability worsening and improvement events}
\usage{
CDEseq(Visits, mconf = 3 * 30.25, tRelapse = 30)
}
\arguments{
\item{Visits}{A data frame consisting of 6 columns: ID, dateEDSS, EDSS, daysPostRelapse (days since most recent relapse), bEDSS (baseline EDSS score), base.date (date of bEDSS).}

\item{mconf}{Confirmation period (days) for EDSS worsening or improvement.}

\item{tRelapse}{Minimum time in days since the most recent relapse to EDSS assessment.}
}
\value{
A data frame.
}
\description{
Identify sequential disability worsening and improvement events confirmed over a specified time period, using roving baseline EDSS. The identification of events is based on clinical visit records, with each record including entries for patient code, visit date, EDSS score, and days since the most recent relapse.
If a baseline EDSS score is not provided, it is determined as the first EDSS score recorded in the dataset outside 30 days (the default) of a relapse.
Following a confirmed disability worsening or improvement event, the minimum EDSS score within the confirmation period, regardless of the recency of a relapse, becomes the new baseline EDSS score.
}
\examples{
data(SampleData)
output<-CDEseq(SampleData)
}
\references{
Sharmin, et al. European Journal of Neurology 2022;29(8):2321-2334.
}
