% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrmc.R
\name{mrmc}
\alias{mrmc}
\title{Multi-Reader Multi-Case ROC Analysis}
\usage{
mrmc(response, test, reader, case, data, cov = jackknife, design = NULL)
}
\arguments{
\item{response}{response metric expressed in terms of a package-supplied
performance \code{\link[=metrics]{metric}}.}

\item{test}{variable of test identifiers.}

\item{reader}{variable of reader identifiers.}

\item{case}{variable of case identifiers.}

\item{data}{data frame containing the \code{response}, \code{test},
\code{reader}, and \code{case} variables.}

\item{cov}{function, function call, or character string naming the
\code{\link[=cov_methods]{method}} to use in calculating performance
metric covariances.}

\item{design}{one of the following study designs: 1 = factorial, 2 = cases
nested within readers, 3 = cases nested within tests, or \code{NULL} to
automatically set the design based on variable codings in data.}
}
\value{
Returns an \code{mrmc} class object with the following elements.
\describe{
  \item{\code{design}}{experimental study design: 1 = factorial, 2 = cases
    nested within readers, 3 = cases nested within tests.}
  \item{\code{vars}}{character names of the analysis factors and reader
    performance metric.}
  \item{\code{fixed}}{logicals indicating whether the reader and case factors
    are treated as fixed in the analysis.}
  \item{\code{aov}}{results from an ordinary analysis of variance.}
  \item{\code{data}}{data frame of computed reader performance metrics for
    the analysis of variance.}
  \item{\code{num_obs}}{number of case observations for each of the computed
    metrics.}
  \item{\code{cov}}{reader performance covariance matrix.}
  \item{\code{mrmc_data}}{data frame of case-specific reader ratings.}
  \item{\code{levels}}{character levels of the true case statuses.}
}
}
\description{
Estimation and comparison of ROC performance metrics for multi-reader
multi-case studies.
}
\details{
Readers and cases are treated as random factors by default.  Either one may
be designated as fixed in calls to \code{mrmc} with the syntax
\code{fixed(<variable name>)}, where \code{<variable name>} is the name of
the reader or case variable.
}
\examples{
\donttest{
## Random readers and cases
(est <- mrmc(empirical_auc(truth, rating), treatment, reader, case,
             data = VanDyke))
plot(est)
summary(est)

## Fixed readers and random cases
est <- mrmc(empirical_auc(truth, rating), treatment, fixed(reader), case,
            data = VanDyke)
summary(est)
}

}
\references{
Dorfman DD, Berbaum KS, and Metz CE (1992). Receiver operating characteristic
rating analysis. Generalization to the population of readers and patients
with the jackknife method. Investigative Radiology, 27: 723–731.

Obuchowski NA and Rockette HE (1995). Hypothesis testing of diagnostic
accuracy for multiple readers and multiple tests: an ANOVA approach with
dependent observations. Communications in Statistics–Simulation and
Computation 24: 285–308.

Hillis SL, Obuchowski NA, Schartz KM, and Berbaum KS (2005). A comparison of
the Dorfman-Berbaum-Metz and Obuchowski-Rockette methods for receiver
operating characteristic (ROC) data. Statisticsin Medicine, 24: 1579–1607.

Hillis SL (2007). A comparison of denominator degrees of freedom methods for
multiple observer ROC analysis. Statistics in Medicine, 26: 596–619.

Hillis SL, Berbaum KS, and Metz CE (2008). Recent developments in the
Dorfman-Berbaum-Metz procedure for multireader ROC study analysis. Academic
Radiology, 15: 647–661.
}
\seealso{
\code{\link{metrics}}, \code{\link{cov_methods}},
\code{\link{parameters}}, \code{\link{plot}}, \code{\link{roc_curves}},
\code{\link{summary}}
}
