% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria_mseP.R
\name{criteria.mseP}
\alias{criteria.mseP}
\title{Calculates the values of the MSE DPs-criterion using the point prior for the MSE(D)-component estimation}
\usage{
criteria.mseP(X1, X2, search.object, eps = 10^-23)
}
\arguments{
\item{X1}{The primary model matrix, with the first column containing the labels of treatments, and the second -- the intercept term.}

\item{X2}{The matrix of potential terms, with the first column containing the labels of treatments.}

\item{search.object}{Object of class \code{\link[=mood]{mood()}} specifying experiment parameters.}

\item{eps}{Computational tolerance, the default value is 10^-23}
}
\value{
A list of values: indicator of whether the evaluation was successful ("eval"), DPs-criterion value -- intercept excluded ("DP"),
Lack-of-fit(DP) criterion value ("LoF"), the MSE(D) component value ("mse"),
the number of pure error degrees of freedom ("df") and the value of the compound criterion ("compound").
}
\description{
This function evaluates the MSE DPs-criterion for given primary and potential model matrices, using point MSE(D)-component estimation. Candidate full model matrices do not have to be orthonormalised.
Components: DPs-, LoF(DP)- and MSE(D)-optimality.
}
\examples{
# Experiment: one 5-level factor, primary model -- full quadratic, X^3 and X^4 potential terms.
ex.mood <- mood(K = 1, Levels = 5, Nruns = 8, criterion.choice = "MSE.P", 
               kappa = list(kappa.DP = 1./3, kappa.LoF = 1./3, kappa.mse = 1./3), 
               model_terms = list(primary.model = "second_order", potential.terms = "x14"))
# Generating candidate sets: primary and full orthonormalised
K <- ex.mood$K
Levels <- ex.mood$Levels 
cand.not.orth <- candidate_set_full(candidate_trt_set(Levels, K), K)
cand.full.orth <- candidate_set_orth(cand.not.orth, ex.mood$primary.terms, ex.mood$potential.terms)
# Choosing a design
index <- c(rep(1,2),3,rep(4,2),rep(5,3))
X.primary <- cand.full.orth[index, c(1, match(ex.mood$primary.terms, colnames(cand.full.orth)))]
X.potential <- cand.full.orth[index, 
(c(1, match(ex.mood$potential.terms, colnames(cand.full.orth))))]
# Evaluating a compound GDP-criterion
criteria.mseP(X.primary, X.potential, ex.mood)
# Output: eval = 1, DP = 4.538023, LoF = 3.895182, mse = 0.6992699, df = 4, compound = 2.312135
}
