% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mic_manipulation.R
\name{get_mic}
\alias{get_mic}
\title{Get MIC meta-data from feature database}
\usage{
get_mic(
  x,
  ids,
  ab_col,
  id_col = NULL,
  as_mic = TRUE,
  prefer_high_mic = TRUE,
  simplify = TRUE
)
}
\arguments{
\item{x}{dataframe containing meta-data}

\item{ids}{vector of IDs to get meta-data for}

\item{ab_col}{column name containing MIC results}

\item{id_col}{column name containing IDs}

\item{as_mic}{return as AMR::as.mic}

\item{prefer_high_mic}{where multiple MIC results per ID, prefer the higher MIC}

\item{simplify}{return as vector of MICs (vs dataframe)}
}
\value{
vector containing MICs, or dataframe of IDs and MICs
}
\description{
This function helps extract MICs from a database of results. It is compatible
with the PATRIC meta data format when used on a tidy_patric_db object,
created using tidy_patric_db().

If more than one MIC is present for a particular observation, the function
can return the higher MIC by setting prefer_high_mic = TRUE. If
prefer_high_mic = FALSE, the lower MIC will be returned.
}
\examples{
df <- data.frame(genome_id = c("a_12", "b_42", "x_21", "x_21", "r_75"),
                 gentamicin = c(0.25, 0.125, 32.0, 16.0, "<0.0125"))
get_mic(df,
        ids = c("b_42", "x_21"),
        ab_col = "gentamicin",
        id_col = "genome_id",
        as_mic = FALSE,
        prefer_high_mic = TRUE,
        simplify = TRUE)
}
