% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_Clustering.R
\name{ChooseK}
\alias{ChooseK}
\title{Cluster Number Selection}
\usage{
ChooseK(
  data,
  k0 = 2,
  k1 = NULL,
  boot = 100,
  init_means = NULL,
  fix_means = FALSE,
  init_covs = NULL,
  init_props = NULL,
  maxit = 10,
  eps = 1e-04,
  report = TRUE
)
}
\arguments{
\item{data}{Numeric data matrix.}

\item{k0}{Minimum number of clusters.}

\item{k1}{Maximum number of clusters.}

\item{boot}{Bootstrap replicates.}

\item{init_means}{Optional list of initial mean vectors.}

\item{fix_means}{Fix the means to their starting value? Must provide initial
values.}

\item{init_covs}{Optional list of initial covariance matrices.}

\item{init_props}{Optional vector of initial cluster proportions.}

\item{maxit}{Maximum number of EM iterations.}

\item{eps}{Minimum acceptable increment in the EM objective.}

\item{report}{Report bootstrap progress?}
}
\value{
List containing \code{Choices}, the recommended number of clusters
  according to each quality metric, and \code{Results}, the mean and standard
  error of the quality metrics at each cluster number evaluated.
}
\description{
Function to choose the number of clusters k. Examines cluster numbers between
k0 and k1. For each cluster number, generates \code{boot} bootstrap data
sets, fits the Gaussian Mixture Model (\code{\link{FitGMM}}), and calculates
quality metrics (\code{\link{ClustQual}}). For each metric, determines the
optimal cluster number \code{k_opt}, and the \code{k_1SE}, the smallest
cluster number whose quality is within 1 SE of the optimum.
}
\examples{
\donttest{
set.seed(100)
mean_list <- list(c(2, 2), c(2, -2), c(-2, 2), c(-2, -2))
data <- rGMM(n = 500, d = 2, k = 4, means = mean_list)
choose_k <- ChooseK(data, k0 = 2, k1 = 6, boot = 10)
choose_k$Choices
}
}
\seealso{
See \code{\link{ClustQual}} for evaluating cluster quality, and \code{\link{FitGMM}}
for estimating the GMM with a specified cluster number.
}
