% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht.R
\name{ht}
\alias{ht}
\title{Show the head and tail of an object}
\usage{
ht(x, n = 6L, m = n, returnList = FALSE, ...)
}
\arguments{
\item{x}{The object to show}

\item{n}{The number of elements to list for the head}

\item{m}{The number of elements to list for the tail}

\item{returnList}{Logical. Should the result be returned as a list}

\item{...}{additional arguments passed to functions (not used at the moment)}
}
\value{
NULL unless returnList is set to TRUE in which case a list is returned
}
\description{
Show both the head and tail of an R object
}
\details{
This function does no error checking and it is up to the user to ensure that the input is indeed symmetric, positive-definite, and a matrix.
}
\examples{
ht(trees)
ht(diag(20))
ht(1:20)
ht(1:20, returnList=TRUE)

}
\author{
Claus Ekstrom, \email{claus@rprimer.dk}.
}
\keyword{print}
