% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{calc.pair.rf.lod}
\alias{calc.pair.rf.lod}
\title{Create recombination matrix from pairwise data file.}
\usage{
calc.pair.rf.lod(fname, weightfn = "lod", ...)
}
\arguments{
\item{fname}{Character string specifying the base name of the file \code{fname.txt} which 
contains the data to be analysed the file should be white space or tab separated.}

\item{weightfn}{Character string specifiying the values to use for the weight 
matrix \code{'lod2'} or \code{'lod'}.}

\item{...}{\code{\link[utils]{read.table}} arguments.}
}
\value{
A list with the following elements:
\item{rf}{A symmetric matrix of recombination fractions.}
\item{nloci}{The number of markers in the analysis.}
\item{locinames}{The names of the markers in the analysis.}
}
\description{
Reads a text file of pairwise recombination fractions and LOD scores and casts 
it into a matrix of recombination fractions and weights.
}
\details{
File names should be of the form \code{fname.txt} and it is assumed that they are in 
a tab or space separated file of the format displayed below. The first entry on 
the first row is the number of markers to be analysed. Underneath this is a 
table in which the first two columns contain marker names, the third column 
contains the pairwise recombination fractions between the markers and the 
fourth column the associated LOD score.  Note that marker names in the first 
column vary more slowly than in the second column. Missing recombination pairs 
are acceptable. Recombination fractions greater than 0.499999 are set to that 
value

\tabular{llll}{
\cr
\code{nmarkers} \tab \tab \tab \cr
\code{marker_1} \tab \code{marker_2} \tab \code{recombination fraction} \tab \code{LOD}\cr
\code{1} \tab \code{2} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
}
}
\examples{
lodrf<-calc.pair.rf.lod(system.file("extdata", "lgI.txt", package="MDSMap"), 
"lod2")
}
