% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdmr.R
\name{.pmdmr}
\alias{.pmdmr}
\title{Function to compute analytic p-values using Davies (1980)}
\usage{
.pmdmr(q, lambda, k, p, n = length(lambda), lim = 50000, acc = 1e-20)
}
\arguments{
\item{q}{Test statistic}

\item{lambda}{Centered distance matrix eigenvalues}

\item{k}{Numerator degrees of freedom for this test statistic}

\item{p}{Total number of predictors in the design matrix (except for the
intercept)}

\item{n}{Sample size}

\item{lim}{Maximum number of integration terms. Realistic values for "lim"
range from 1,000 if the procedure is to be called repeatedly up to 50,000 if
it is to be called only occasionally}

\item{acc}{Error bound. Suitable values for "acc" range from 0.001 to 0.00005
which should be adequate for most statistical purposes.}
}
\value{
Output of CompQuadForm::davies()
}
\description{
Compute analytic MDMR p-values
}
\references{
Davies, R. B. (1980). The Distribution of a Linear Combination of
 chi-square Random Variables. Journal of the Royal Statistical Society.
 Series C (Applied Statistics), 29(3), 323-333.

 Duchesne, P., & De Micheaux, P. L. (2010). Computing the distribution of
 quadratic forms: Further comparisons between the Liu-Tang-Zhang
 approximation and exact methods. Computational Statistics and Data
 Analysis, 54(4), 858-862.

 McArtor, D. B., Lubke, G. H., & Bergeman, C. S. (2017). Extending
 multivariate distance matrix regression with an effect size measure and the
 distribution of the test statistic. Psychometrika, 82, 1052-1077.
}
\author{
Daniel B. McArtor (dmcartor@gmail.com) [aut, cre]
}
