% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkov.R
\name{rmarkov}
\alias{rmarkov}
\title{Generate a sample of a discrete-state Markov chain}
\usage{
rmarkov(n, P, start = rep(1, ncol(P)))
}
\arguments{
\item{n}{length of the generated sequence.}

\item{P}{transition matrix (rows are normalized to sum to 1).}

\item{start}{vector with nonnegative values that defines the discrete starting
distribution at t=0 (\code{start} is normalized to sum to 1). The default is
a discrete uniform distribution.}
}
\description{
Generates a sequence of discrete states from a discrete-time Markov chain with transition matrix \code{P}.
}
\examples{
P <- matrix(c(.30, .50, .20,
              .05, .25, .70,
              .00, .10, .90), 3, 3, byrow=TRUE)
rmarkov(50, P)
}
