% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma-class.R, R/run.functions.R
\name{plot.nma}
\alias{plot.nma}
\alias{nma.run}
\title{Run an NMA model}
\usage{
\method{plot}{nma}(x, bydose = TRUE, scales = "free_x", ...)

nma.run(
  network,
  method = "common",
  likelihood = NULL,
  link = NULL,
  priors = NULL,
  sdscale = FALSE,
  warn.rhat = TRUE,
  n.iter = 20000,
  drop.discon = TRUE,
  UME = FALSE,
  pD = TRUE,
  parameters.to.save = NULL,
  ...
)
}
\arguments{
\item{x}{An object of \code{class("nma")}}

\item{bydose}{A boolean object indicating whether to plot responses with dose
on the x-axis (\code{TRUE}) to be able to examine potential dose-response shapes, or
to plot a conventional forest plot with all treatments on the same plot (\code{FALSE})}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{...}{Arguments to be sent to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}}

\item{network}{An object of class \code{mbnma.network}.}

\item{method}{Indicates the type of split (treatment-level) NMA to perform when \code{overlay.split=TRUE}. Can
take either \code{"common"} or \code{"random"}.}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}), be assigned the value \code{"identity"} for
an identity link function, or be assigned the value \code{"smd"} for modelling Standardised Mean Differences using an
identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}

\item{priors}{A named list of parameter values (without indices) and
replacement prior distribution values given as strings
\strong{using distributions as specified in JAGS syntax} (see \insertCite{jagsmanual;textual}{MBNMAdose}). Note
that normal distributions in JAGS are specified as \deqn{N(\mu, prec)}, where \deqn{prec = 1 / {\sigma^2}}.}

\item{sdscale}{Logical object to indicate whether to write a model that specifies a reference SD
for standardising when modelling using Standardised Mean Differences. Specifying \code{sdscale=TRUE}
will therefore only modify the model if link function is set to SMD (\code{link="smd"}).}

\item{warn.rhat}{A boolean object to indicate whether to return a warning if Rhat values
for any monitored parameter are >1.02 (suggestive of non-convergence).}

\item{n.iter}{number of total iterations per chain (including burn in; default: 20000)}

\item{drop.discon}{A boolean object that indicates whether or not to drop disconnected
studies from the network.}

\item{UME}{A boolean object to indicate whether to fit an Unrelated Mean Effects model
that does not assume consistency and so can be used to test if the consistency
assumption is valid.}

\item{pD}{logical; if \code{TRUE} (the default) then adds the computation of pD, using the method
of \insertCite{plummer2008}{MBNMAdose}. If \code{FALSE} then uses the
approximation of \code{pD=var(deviance) / 2} (often referred to as pV).}

\item{parameters.to.save}{A character vector containing names of parameters
to monitor in JAGS}
}
\description{
Used for calculating treatment-level NMA results, either when comparing MBNMA models to models that
make no assumptions regarding dose-response , or to estimate split results for \code{overlay.split}.
Results can also be compared between consistency (\code{UME=FALSE}) and inconsistency
(\code{UME=TRUE}) models to test the validity of the consistency assumption at the treatment-level.
}
\section{Functions}{
\itemize{
\item \code{plot(nma)}: Plot outputs from treatment-level NMA models

Results can be plotted either as a single forest plot, or facetted by agent
and plotted with increasing dose in order to identify potential dose-response
relationships. If Placebo (or any agents with dose=0) is included in the network
then this will be used as the reference treatment, but if it is not then results
will be plotted versus the network reference used in the NMA object (\code{x}).

}}
\examples{
\donttest{
# Run random effects NMA on the alogliptin dataset
alognet <- mbnma.network(alog_pcfb)
nma <- nma.run(alognet, method="random")
print(nma)
plot(nma)

# Run common effects NMA keeping treatments that are disconnected in the NMA
goutnet <- mbnma.network(gout)
nma <- nma.run(goutnet, method="common", drop.discon=FALSE)

# Run an Unrelated Mean Effects (UME) inconsistency model on triptans dataset
tripnet <- mbnma.network(triptans)
ume <- nma.run(tripnet, method="random", UME=TRUE)
}

}
