% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UM.suff.R
\name{UM.suff}
\alias{UM.suff}
\title{Sufficient statistics for the Unconstrained-Multinomial model}
\usage{
UM.suff(X, popId)
}
\arguments{
\item{X}{Genotype adata.  Either a \code{N x 4} matrix with \code{NA}'s indicating duplicates or a \code{N x 5} column data.frame with the first column being the \code{popId}.}

\item{popId}{grouping variable for \code{X}. Must be supplied if \code{X} has 4 columns.}
}
\value{
A list with elements:
\itemize{
\item \code{A}: Vector of unique alleles names.  The allele numbers in the following quantities correspond to the indices of \code{A}.
\item \code{G}: 4-column matrix of unique genotype combinations.  The presence of 0's indicates that less than four alleles were amplified indicating that a given genotype either has less than 4 distinct alleles or that some alleles are duplicated.
\item \code{tab}: Observed data in a simplified numerical format.  This is a contingency table with rows given by the unique elements of \code{popId} and columns given by each row of \code{G}.
}
}
\description{
Converts a matrix or data.frame of genotype data into the sufficient statistics required to fit a Dirichlet-Multinomial hierarchical model.
}
\examples{
# sufficient statistics in 3 lakes

X <- fish215[fish215$Lake \%in\% c("Hogan", "Manitou", "Simcoe"),]
suff <- UM.suff(X)

suff$A # allele names
suff$G # unique genotypes
suff$tab # contingency table
}
